/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.export.api;

import java.io.OutputStream;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.api.DatabaseExportOutputStream;
import org.killbill.billing.util.api.ExportUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.export.dao.CSVExportOutputStream;
import org.killbill.billing.util.export.dao.DatabaseExportDao;

public class DefaultExportUserApi
implements ExportUserApi {
    private final DatabaseExportDao exportDao;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public DefaultExportUserApi(DatabaseExportDao exportDao, InternalCallContextFactory internalCallContextFactory) {
        this.exportDao = exportDao;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public void exportDataForAccount(UUID accountId, DatabaseExportOutputStream out, CallContext context) {
        InternalCallContext internalContext = this.internalCallContextFactory.createInternalCallContext(accountId, context);
        this.exportDao.exportDataForAccount(out, (InternalTenantContext)internalContext);
    }

    public void exportDataAsCSVForAccount(UUID accountId, OutputStream out, CallContext context) {
        this.exportDataForAccount(accountId, new CSVExportOutputStream(out), context);
    }
}

