/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.export.dao;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.killbill.billing.util.api.ColumnInfo;
import org.killbill.billing.util.api.DatabaseExportOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExportOutputStream
extends OutputStream
implements DatabaseExportOutputStream {
    private static final CsvMapper mapper = new CsvMapper();
    private final OutputStream delegate;
    private String currentTableName;
    private CsvSchema currentCSVSchema;
    private ObjectWriter writer;
    private boolean shouldWriteHeader = false;

    public CSVExportOutputStream(OutputStream delegate) {
        this.delegate = delegate;
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void newTable(String tableName, List<ColumnInfo> columnsForTable) {
        this.currentTableName = tableName;
        CsvSchema.Builder builder = CsvSchema.builder();
        builder.disableQuoteChar();
        builder.setColumnSeparator('|');
        for (ColumnInfo columnInfo : columnsForTable) {
            builder.addColumn(columnInfo.getColumnName(), this.getColumnTypeFromSqlType(columnInfo.getDataType()));
        }
        this.currentCSVSchema = builder.build();
        this.writer = mapper.writer((FormatSchema)this.currentCSVSchema);
        this.shouldWriteHeader = true;
    }

    public void write(Map<String, Object> row) throws IOException {
        byte[] bytes;
        if (this.shouldWriteHeader) {
            this.write(String.format("-- %s ", this.currentTableName).getBytes());
            bytes = mapper.writer((FormatSchema)this.currentCSVSchema.withHeader()).writeValueAsBytes(row);
            this.shouldWriteHeader = false;
        } else {
            bytes = this.writer.writeValueAsBytes(row);
        }
        this.write(bytes);
    }

    private CsvSchema.ColumnType getColumnTypeFromSqlType(String dataType) {
        if (dataType == null) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("bigint".equals(dataType)) {
            return CsvSchema.ColumnType.NUMBER_OR_STRING;
        }
        if ("blob".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("char".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("date".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("datetime".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("decimal".equals(dataType)) {
            return CsvSchema.ColumnType.NUMBER_OR_STRING;
        }
        if ("enum".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("int".equals(dataType)) {
            return CsvSchema.ColumnType.NUMBER_OR_STRING;
        }
        if ("longblob".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("longtext".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("mediumblob".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("mediumtext".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("set".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("smallint".equals(dataType)) {
            return CsvSchema.ColumnType.NUMBER_OR_STRING;
        }
        if ("text".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("time".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("timestamp".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("tinyint".equals(dataType)) {
            return CsvSchema.ColumnType.NUMBER_OR_STRING;
        }
        if ("varbinary".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        if ("varchar".equals(dataType)) {
            return CsvSchema.ColumnType.STRING;
        }
        return CsvSchema.ColumnType.STRING;
    }
}

