/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.export.dao;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.api.ColumnInfo;
import org.killbill.billing.util.api.DatabaseExportOutputStream;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.validation.DefaultColumnInfo;
import org.killbill.billing.util.validation.dao.DatabaseSchemaDao;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.tweak.HandleCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DatabaseExportDao {
    private final DatabaseSchemaDao databaseSchemaDao;
    private final IDBI dbi;

    @Inject
    public DatabaseExportDao(DatabaseSchemaDao databaseSchemaDao, IDBI dbi) {
        this.databaseSchemaDao = databaseSchemaDao;
        this.dbi = dbi;
    }

    public void exportDataForAccount(DatabaseExportOutputStream out, InternalTenantContext context) {
        if (context.getAccountRecordId() == null || context.getTenantRecordId() == null) {
            return;
        }
        List<DefaultColumnInfo> columns = this.databaseSchemaDao.getColumnInfoList();
        if (columns.size() == 0) {
            return;
        }
        ArrayList<ColumnInfo> columnsForTable = new ArrayList<ColumnInfo>();
        String lastSeenTableName = columns.get(0).getTableName();
        for (ColumnInfo columnInfo : columns) {
            if (!columnInfo.getTableName().equals(lastSeenTableName)) {
                this.exportDataForAccountAndTable(out, columnsForTable, context);
                lastSeenTableName = columnInfo.getTableName();
                columnsForTable.clear();
            }
            columnsForTable.add(columnInfo);
        }
        this.exportDataForAccountAndTable(out, columnsForTable, context);
    }

    private void exportDataForAccountAndTable(final DatabaseExportOutputStream out, List<ColumnInfo> columnsForTable, final InternalTenantContext context) {
        TableType tableType = TableType.OTHER;
        String tableName = columnsForTable.get(0).getTableName();
        if (TableName.ACCOUNT.getTableName().equals(tableName)) {
            tableType = TableType.KB_ACCOUNT;
        } else if (TableName.ACCOUNT_HISTORY.getTableName().equals(tableName)) {
            tableType = TableType.KB_ACCOUNT_HISTORY;
        }
        boolean firstColumn = true;
        final StringBuilder queryBuilder = new StringBuilder("select ");
        for (ColumnInfo column : columnsForTable) {
            if (!firstColumn) {
                queryBuilder.append(", ");
            } else {
                firstColumn = false;
            }
            queryBuilder.append(column.getColumnName());
            if (tableType != TableType.OTHER) continue;
            if (column.getColumnName().equals(TableType.KB_PER_ACCOUNT.getAccountRecordIdColumnName())) {
                tableType = TableType.KB_PER_ACCOUNT;
                continue;
            }
            if (!column.getColumnName().equals(TableType.NOTIFICATION.getAccountRecordIdColumnName())) continue;
            tableType = TableType.NOTIFICATION;
        }
        if (tableType == TableType.OTHER) {
            return;
        }
        queryBuilder.append(" from ").append(tableName).append(" where ").append(tableType.getAccountRecordIdColumnName()).append(" = :accountRecordId and ").append(tableType.getTenantRecordIdColumnName()).append("  = :tenantRecordId");
        out.newTable(tableName, columnsForTable);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void withHandle(Handle handle) throws Exception {
                ResultIterator iterator = ((Query)((Query)handle.createQuery(queryBuilder.toString()).bind("accountRecordId", context.getAccountRecordId())).bind("tenantRecordId", context.getTenantRecordId())).iterator();
                try {
                    while (iterator.hasNext()) {
                        Map row = (Map)iterator.next();
                        for (String k : row.keySet()) {
                            Object value = row.get(k);
                            if (!(value instanceof Blob)) continue;
                            Blob blob = (Blob)value;
                            row.put(k, blob.getBytes(0L, (int)blob.length()));
                        }
                        out.write(row);
                    }
                }
                finally {
                    iterator.close();
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TableType {
        KB_ACCOUNT("record_id", "tenant_record_id"),
        KB_ACCOUNT_HISTORY("target_record_id", "tenant_record_id"),
        KB_PER_ACCOUNT("account_record_id", "tenant_record_id"),
        NOTIFICATION("search_key1", "search_key2"),
        OTHER(null, null);

        private final String accountRecordIdColumnName;
        private final String tenantRecordIdColumnName;

        private TableType(String accountRecordIdColumnName, String tenantRecordIdColumnName) {
            this.accountRecordIdColumnName = accountRecordIdColumnName;
            this.tenantRecordIdColumnName = tenantRecordIdColumnName;
        }

        public String getAccountRecordIdColumnName() {
            return this.accountRecordIdColumnName;
        }

        public String getTenantRecordIdColumnName() {
            return this.tenantRecordIdColumnName;
        }
    }
}

