/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jcache.JCacheGaugeSet;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.killbill.billing.util.config.definition.EhCacheConfig;
import org.killbill.xmlloader.UriAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CacheProviderBase {
    private static final String PROP_METRIC_REG_JCACHE_STATISTICS = "jcache.statistics";
    private final MetricRegistry metricRegistry;
    final URL xmlConfigurationURL;

    CacheProviderBase(MetricRegistry metricRegistry, EhCacheConfig cacheConfig) {
        this.metricRegistry = metricRegistry;
        try {
            this.xmlConfigurationURL = UriAccessor.toURL((String)cacheConfig.getCacheConfigLocation());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    <K, V> Cache<K, V> createCache(CacheManager cacheManager, String cacheName, Class<K> keyType, Class<V> valueType) {
        cacheManager.destroyCache(cacheName);
        MutableConfiguration configuration = new MutableConfiguration().setTypes(keyType, valueType).setStoreByValue(false);
        Cache cache = cacheManager.createCache(cacheName, (Configuration)configuration);
        Preconditions.checkState((!cache.isClosed() ? 1 : 0) != 0, (String)"Cache '%s' should not be closed", (Object)cacheName);
        this.metricRegistry.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return name != null && name.startsWith(CacheProviderBase.PROP_METRIC_REG_JCACHE_STATISTICS);
            }
        });
        this.metricRegistry.register(PROP_METRIC_REG_JCACHE_STATISTICS, (Metric)new JCacheGaugeSet());
        return cache;
    }
}

