/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.MetricRegistry;
import java.net.URISyntaxException;
import java.util.Set;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.inject.Provider;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.config.definition.EhCacheConfig;
import org.killbill.billing.util.glue.CacheProviderBase;
import org.killbill.billing.util.glue.EhcacheLoggingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Eh107CacheManagerProvider
extends CacheProviderBase
implements Provider<CacheManager> {
    private static final Logger logger = LoggerFactory.getLogger(Eh107CacheManagerProvider.class);
    private static final EhcacheLoggingListener ehcacheLoggingListener = new EhcacheLoggingListener();
    private final Set<BaseCacheLoader> cacheLoaders;

    @Inject
    public Eh107CacheManagerProvider(MetricRegistry metricRegistry, EhCacheConfig cacheConfig, Set<BaseCacheLoader> cacheLoaders) {
        super(metricRegistry, cacheConfig);
        this.cacheLoaders = cacheLoaders;
    }

    public CacheManager get() {
        CacheManager cacheManager;
        CachingProvider cachingProvider = Caching.getCachingProvider();
        try {
            cacheManager = cachingProvider.getCacheManager(this.xmlConfigurationURL.toURI(), this.getClass().getClassLoader());
        }
        catch (RuntimeException e) {
            logger.error("Unable to read ehcache.xml, using default configuration", (Throwable)e);
            cacheManager = cachingProvider.getCacheManager();
        }
        catch (URISyntaxException e) {
            logger.error("Unable to read ehcache.xml, using default configuration", (Throwable)e);
            cacheManager = cachingProvider.getCacheManager();
        }
        ((InternalCacheManager)cacheManager.unwrap(InternalCacheManager.class)).deregisterListener((CacheManagerListener)ehcacheLoggingListener);
        ((InternalCacheManager)cacheManager.unwrap(InternalCacheManager.class)).registerListener((CacheManagerListener)ehcacheLoggingListener);
        for (BaseCacheLoader cacheLoader : this.cacheLoaders) {
            this.createCache(cacheManager, cacheLoader.getCacheType().getCacheName(), cacheLoader.getCacheType().getKeyType(), cacheLoader.getCacheType().getValueType());
        }
        return cacheManager;
    }
}

