/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectDAO;
import org.ehcache.Cache;
import org.ehcache.integrations.shiro.EhcacheShiro;
import org.ehcache.integrations.shiro.EhcacheShiroManager;
import org.killbill.billing.util.config.definition.EhCacheConfig;
import org.killbill.billing.util.glue.CacheProviderBase;
import org.killbill.billing.util.glue.KillBillSubjectDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheShiroManagerProvider
extends CacheProviderBase
implements Provider<EhcacheShiroManager> {
    private final SecurityManager securityManager;
    private final javax.cache.CacheManager eh107CacheManager;
    private final org.ehcache.CacheManager ehcacheCacheManager;

    @Inject
    public EhcacheShiroManagerProvider(SecurityManager securityManager, javax.cache.CacheManager eh107CacheManager, MetricRegistry metricRegistry, EhCacheConfig cacheConfig) {
        super(metricRegistry, cacheConfig);
        this.securityManager = securityManager;
        this.eh107CacheManager = eh107CacheManager;
        this.ehcacheCacheManager = this.getEhcacheManager();
    }

    public EhcacheShiroManager get() {
        EhcacheShiroManagerWrapper shiroEhCacheManager = new EhcacheShiroManagerWrapper(this);
        shiroEhCacheManager.setCacheManager(this.ehcacheCacheManager);
        if (this.securityManager instanceof DefaultSecurityManager) {
            DefaultSecurityManager securityManager = (DefaultSecurityManager)this.securityManager;
            securityManager.setCacheManager((CacheManager)shiroEhCacheManager);
            securityManager.setSubjectDAO((SubjectDAO)new KillBillSubjectDAO());
        }
        return shiroEhCacheManager;
    }

    private org.ehcache.CacheManager getEhcacheManager() {
        try {
            Field f = this.eh107CacheManager.getClass().getDeclaredField("ehCacheManager");
            f.setAccessible(true);
            return (org.ehcache.CacheManager)f.get(this.eh107CacheManager);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EhcacheShiroManagerWrapper
    extends EhcacheShiroManager {
        private final Logger log = LoggerFactory.getLogger(EhcacheShiroManagerWrapper.class);
        private final EhcacheShiroManagerProvider ehcacheShiroManagerProvider;

        EhcacheShiroManagerWrapper(EhcacheShiroManagerProvider ehcacheShiroManagerProvider2) {
            this.ehcacheShiroManagerProvider = ehcacheShiroManagerProvider2;
        }

        public <K, V> org.apache.shiro.cache.Cache<K, V> getCache(String name) throws CacheException {
            this.log.trace("Acquiring EhcacheShiro instance named [{}]", (Object)name);
            Cache cache = this.getCacheManager().getCache(name, Object.class, Object.class);
            if (cache == null) {
                this.log.info("Cache with name {} does not yet exist.  Creating now.", (Object)name);
                this.ehcacheShiroManagerProvider.createCache(EhcacheShiroManagerProvider.this.eh107CacheManager, name, Object.class, Object.class);
                cache = this.getCacheManager().getCache(name, Object.class, Object.class);
                this.log.info("Added EhcacheShiro named [{}]", (Object)name);
            } else {
                this.log.info("Using existing EhcacheShiro named [{}]", (Object)name);
            }
            return new EhcacheShiro(cache);
        }
    }
}

