/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.killbill.billing.lifecycle.ServiceFinder;
import org.killbill.billing.util.broadcast.dao.BroadcastModelDao;
import org.killbill.billing.util.dao.AuditLogModelDaoMapper;
import org.killbill.billing.util.dao.EntityHistoryModelDaoMapperFactory;
import org.killbill.billing.util.dao.RecordIdIdMappingsMapper;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.nodes.dao.NodeInfoModelDao;
import org.killbill.billing.util.security.shiro.dao.RolesPermissionsModelDao;
import org.killbill.billing.util.security.shiro.dao.SessionModelDao;
import org.killbill.billing.util.security.shiro.dao.UserModelDao;
import org.killbill.billing.util.security.shiro.dao.UserRolesModelDao;
import org.killbill.billing.util.validation.dao.DatabaseSchemaSqlDao;
import org.killbill.bus.dao.BusEventModelDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDBISetup {
    public static List<? extends ResultSetMapperFactory> mapperFactoriesToRegister() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new LowerToCamelBeanMapperFactory(SessionModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(BroadcastModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(NodeInfoModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(UserModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(UserRolesModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(RolesPermissionsModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(BusEventModelDao.class));
        builder.add((Object)new LowerToCamelBeanMapperFactory(NotificationEventModelDao.class));
        ServiceFinder serviceFinder = new ServiceFinder(IDBISetup.class.getClassLoader(), EntitySqlDao.class.getName());
        for (Class sqlObjectType : serviceFinder.getServices()) {
            if (sqlObjectType.getGenericInterfaces() == null || sqlObjectType.getAnnotation(RegisterMapper.class) != null) continue;
            for (int i = 0; i < sqlObjectType.getGenericInterfaces().length; ++i) {
                if (!(sqlObjectType.getGenericInterfaces()[i] instanceof ParameterizedType)) continue;
                ParameterizedType type = (ParameterizedType)sqlObjectType.getGenericInterfaces()[i];
                for (int j = 0; j < type.getActualTypeArguments().length; ++j) {
                    Class modelClazz;
                    Type modelType = type.getActualTypeArguments()[j];
                    if (!(modelType instanceof Class) || !Entity.class.isAssignableFrom(modelClazz = (Class)modelType)) continue;
                    builder.add((Object)new LowerToCamelBeanMapperFactory(modelClazz));
                    builder.add((Object)new EntityHistoryModelDaoMapperFactory(modelClazz, sqlObjectType));
                }
            }
        }
        return builder.build();
    }

    public static List<? extends ResultSetMapper> mappersToRegister() {
        return ImmutableList.builder().add((Object)new AuditLogModelDaoMapper()).add((Object)new RecordIdIdMappingsMapper()).add((Object)new DatabaseSchemaSqlDao.ColumnInfoMapper()).build();
    }
}

