/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniRealmProvider
implements Provider<IniRealm> {
    private static final Logger log = LoggerFactory.getLogger(IniRealmProvider.class);
    private final SecurityConfig securityConfig;

    @Inject
    public IniRealmProvider(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public IniRealm get() {
        try {
            IniSecurityManagerFactory factory = new IniSecurityManagerFactory(this.securityConfig.getShiroResourcePath());
            DefaultSecurityManager securityManager = (DefaultSecurityManager)factory.getInstance();
            Collection realms = securityManager.getRealms();
            IniRealm iniRealm = null;
            if (realms == null || realms.isEmpty()) {
                iniRealm = new IniRealm(this.securityConfig.getShiroResourcePath());
            } else {
                for (Realm cur : realms) {
                    if (!(cur instanceof IniRealm)) continue;
                    iniRealm = (IniRealm)cur;
                    break;
                }
            }
            if (iniRealm != null) {
                iniRealm.setAuthenticationCachingEnabled(true);
                return iniRealm;
            }
            throw new ConfigurationException();
        }
        catch (ConfigurationException e) {
            log.warn("Unable to configure RBAC", (Throwable)e);
            return new IniRealm();
        }
    }
}

