/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.killbill.billing.util.config.definition.RbacConfig;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionDao;
import org.skife.jdbi.v2.IDBI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCSessionDaoProvider
implements Provider<JDBCSessionDao> {
    private final SessionManager sessionManager;
    private final IDBI dbi;
    private final RbacConfig rbacConfig;

    @Inject
    public JDBCSessionDaoProvider(IDBI dbi, SessionManager sessionManager, RbacConfig rbacConfig) {
        this.sessionManager = sessionManager;
        this.dbi = dbi;
        this.rbacConfig = rbacConfig;
    }

    public JDBCSessionDao get() {
        JDBCSessionDao jdbcSessionDao = new JDBCSessionDao(this.dbi);
        if (this.sessionManager instanceof DefaultSessionManager) {
            DefaultSessionManager defaultSessionManager = (DefaultSessionManager)this.sessionManager;
            defaultSessionManager.setSessionDAO((SessionDAO)jdbcSessionDao);
            defaultSessionManager.setGlobalSessionTimeout(this.rbacConfig.getGlobalSessionTimeout().getMillis());
        }
        return jdbcSessionDao;
    }
}

