/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.shiro.aop.AnnotationMethodInterceptor;
import org.apache.shiro.aop.AnnotationResolver;
import org.apache.shiro.guice.aop.ShiroAopModule;
import org.killbill.billing.util.glue.KillBillShiroModule;
import org.killbill.billing.util.security.AnnotationHierarchicalResolver;
import org.killbill.billing.util.security.AopAllianceMethodInterceptorAdapter;
import org.killbill.billing.util.security.PermissionAnnotationHandler;
import org.killbill.billing.util.security.PermissionAnnotationMethodInterceptor;

public class KillBillShiroAopModule
extends ShiroAopModule {
    private final AnnotationHierarchicalResolver resolver = new AnnotationHierarchicalResolver();

    protected AnnotationResolver createAnnotationResolver() {
        return this.resolver;
    }

    protected void configureInterceptors(AnnotationResolver resolver) {
        super.configureInterceptors(resolver);
        if (!KillBillShiroModule.isRBACEnabled()) {
            return;
        }
        PermissionAnnotationHandler permissionAnnotationHandler = new PermissionAnnotationHandler();
        this.requestInjection((Object)permissionAnnotationHandler);
        PermissionAnnotationMethodInterceptor methodInterceptor = new PermissionAnnotationMethodInterceptor(permissionAnnotationHandler, resolver);
        this.bindShiroInterceptorWithHierarchy((AnnotationMethodInterceptor)methodInterceptor);
    }

    protected final void bindShiroInterceptorWithHierarchy(final AnnotationMethodInterceptor methodInterceptor) {
        this.bindInterceptor(Matchers.any(), (Matcher)new AbstractMatcher<Method>(){

            public boolean matches(Method method) {
                Class annotation = methodInterceptor.getHandler().getAnnotationClass();
                return KillBillShiroAopModule.this.resolver.getAnnotationFromMethod(method, annotation) != null;
            }
        }, new MethodInterceptor[]{new AopAllianceMethodInterceptorAdapter((org.apache.shiro.aop.MethodInterceptor)methodInterceptor)});
    }
}

