/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.binder.AnnotatedBindingBuilder;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.config.definition.RbacConfig;
import org.killbill.billing.util.glue.EhcacheShiroManagerProvider;
import org.killbill.billing.util.glue.IniRealmProvider;
import org.killbill.billing.util.glue.JDBCSessionDaoProvider;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionDao;
import org.killbill.billing.util.security.shiro.realm.KillBillJdbcRealm;
import org.killbill.billing.util.security.shiro.realm.KillBillJndiLdapRealm;
import org.killbill.billing.util.security.shiro.realm.KillBillOktaRealm;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillShiroModule
extends ShiroModule {
    public static final String KILLBILL_LDAP_PROPERTY = "killbill.server.ldap";
    public static final String KILLBILL_OKTA_PROPERTY = "killbill.server.okta";
    public static final String KILLBILL_RBAC_PROPERTY = "killbill.server.rbac";
    private final KillbillConfigSource configSource;

    public static boolean isLDAPEnabled() {
        return Boolean.parseBoolean(System.getProperty(KILLBILL_LDAP_PROPERTY, "false"));
    }

    public static boolean isOktaEnabled() {
        return Boolean.parseBoolean(System.getProperty(KILLBILL_OKTA_PROPERTY, "false"));
    }

    public static boolean isRBACEnabled() {
        return Boolean.parseBoolean(System.getProperty(KILLBILL_RBAC_PROPERTY, "true"));
    }

    public KillBillShiroModule(KillbillConfigSource configSource) {
        this.configSource = configSource;
    }

    protected void configureShiro() {
        RbacConfig config = (RbacConfig)new ConfigurationObjectFactory(new ConfigSource(){

            public String getString(String propertyName) {
                return KillBillShiroModule.this.configSource.getString(propertyName);
            }
        }).build(RbacConfig.class);
        this.bind(RbacConfig.class).toInstance((Object)config);
        this.bindRealm().toProvider(IniRealmProvider.class).asEagerSingleton();
        this.configureJDBCRealm();
        this.configureLDAPRealm();
    }

    protected void configureJDBCRealm() {
        this.bindRealm().to(KillBillJdbcRealm.class).asEagerSingleton();
    }

    protected void configureLDAPRealm() {
        if (KillBillShiroModule.isLDAPEnabled()) {
            this.bindRealm().to(KillBillJndiLdapRealm.class).asEagerSingleton();
        }
    }

    protected void configureOktaRealm() {
        if (KillBillShiroModule.isOktaEnabled()) {
            this.bindRealm().to(KillBillOktaRealm.class).asEagerSingleton();
        }
    }

    protected void bindSecurityManager(AnnotatedBindingBuilder<? super SecurityManager> bind) {
        super.bindSecurityManager(bind);
        this.bind(CacheManager.class).toProvider(EhcacheShiroManagerProvider.class).asEagerSingleton();
    }

    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
        bind.to(DefaultSessionManager.class).asEagerSingleton();
        this.bind(JDBCSessionDao.class).toProvider(JDBCSessionDaoProvider.class).asEagerSingleton();
    }
}

