/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.util.CollectionUtils;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionDao;

public class KillBillSubjectDAO
extends DefaultSubjectDAO {
    protected void saveToSession(Subject subject) {
        boolean updatesDisabled = false;
        Session session = subject.getSession(false);
        if (session == null && !CollectionUtils.isEmpty((PrincipalCollection)subject.getPrincipals())) {
            session = subject.getSession();
            updatesDisabled = this.disableUpdatesForSession(subject, session);
        }
        super.saveToSession(subject);
        if (updatesDisabled) {
            this.enableUpdatesForSession(subject, session);
        }
    }

    private boolean disableUpdatesForSession(Subject subject, Session session) {
        JDBCSessionDao sessionDAO = this.getJDBCSessionDao(subject);
        if (sessionDAO != null) {
            sessionDAO.disableUpdatesForSession(session);
            return true;
        }
        return false;
    }

    private void enableUpdatesForSession(Subject subject, Session session) {
        JDBCSessionDao sessionDAO = this.getJDBCSessionDao(subject);
        if (sessionDAO != null) {
            sessionDAO.enableUpdatesForSession(session);
        }
    }

    private JDBCSessionDao getJDBCSessionDao(Subject subject) {
        DefaultSessionManager sessionManager;
        SessionsSecurityManager securityManager;
        DelegatingSubject delegatingSubject;
        if (subject instanceof DelegatingSubject && (delegatingSubject = (DelegatingSubject)subject).getSecurityManager() instanceof SessionsSecurityManager && (securityManager = (SessionsSecurityManager)delegatingSubject.getSecurityManager()).getSessionManager() instanceof DefaultSessionManager && (sessionManager = (DefaultSessionManager)securityManager.getSessionManager()).getSessionDAO() instanceof JDBCSessionDao) {
            return (JDBCSessionDao)sessionManager.getSessionDAO();
        }
        return null;
    }
}

