/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.killbill.billing.KillbillApi;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;

public class KillbillApiAopModule
extends AbstractModule {
    private static final Matcher<Method> SYNTHETIC_METHOD_MATCHER = new Matcher<Method>(){

        public boolean matches(Method method) {
            return method.isSynthetic();
        }

        public Matcher<Method> and(Matcher<? super Method> other) {
            throw new UnsupportedOperationException();
        }

        public Matcher<Method> or(Matcher<? super Method> other) {
            throw new UnsupportedOperationException();
        }
    };

    protected void configure() {
        this.bindInterceptor(Matchers.subclassesOf(KillbillApi.class), Matchers.not(SYNTHETIC_METHOD_MATCHER), new MethodInterceptor[]{new ProfilingMethodInterceptor()});
    }

    public static class ProfilingMethodInterceptor
    implements MethodInterceptor {
        private final Profiling prof = new Profiling();

        public Object invoke(final MethodInvocation invocation) throws Throwable {
            return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.API, invocation.getMethod().getName(), new Profiling.WithProfilingCallback(){

                public Object execute() throws Throwable {
                    return invocation.proceed();
                }
            });
        }
    }
}

