/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.glue.KillBillModule;
import org.killbill.billing.util.security.api.DefaultSecurityApi;
import org.killbill.billing.util.security.api.DefaultSecurityService;
import org.killbill.billing.util.security.api.SecurityService;
import org.killbill.billing.util.security.shiro.dao.DefaultUserDao;
import org.killbill.billing.util.security.shiro.dao.UserDao;
import org.skife.config.ConfigurationObjectFactory;

public class SecurityModule
extends KillBillModule {
    public SecurityModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    public void configure() {
        this.installConfig();
        this.installDao();
        this.installSecurityApi();
        this.installSecurityService();
    }

    protected void installDao() {
        this.bind(UserDao.class).to(DefaultUserDao.class).asEagerSingleton();
    }

    private void installConfig() {
        SecurityConfig securityConfig = (SecurityConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(SecurityConfig.class);
        this.bind(SecurityConfig.class).toInstance((Object)securityConfig);
    }

    private void installSecurityApi() {
        this.bind(SecurityApi.class).to(DefaultSecurityApi.class).asEagerSingleton();
    }

    protected void installSecurityService() {
        this.bind(SecurityService.class).to(DefaultSecurityService.class).asEagerSingleton();
    }
}

