/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes.dao;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.killbill.billing.util.nodes.dao.NodeInfoDao;
import org.killbill.billing.util.nodes.dao.NodeInfoModelDao;
import org.killbill.billing.util.nodes.dao.NodeInfoSqlDao;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeInfoDao
implements NodeInfoDao {
    private final IDBI dbi;
    private final Clock clock;

    @Inject
    public DefaultNodeInfoDao(IDBI dbi, Clock clock) {
        this.dbi = dbi;
        this.clock = clock;
    }

    @Override
    public void create(final NodeInfoModelDao nodeInfoModelDao) {
        this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                if (sqlDao.getByNodeName(nodeInfoModelDao.getNodeName()) != null) {
                    sqlDao.delete(nodeInfoModelDao.getNodeName());
                }
                sqlDao.create(nodeInfoModelDao);
                return null;
            }
        });
    }

    @Override
    public void updateNodeInfo(final String nodeName, final String nodeInfo) {
        this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                Date updateDate = DefaultNodeInfoDao.this.clock.getUTCNow().toDate();
                sqlDao.updateNodeInfo(nodeName, nodeInfo, updateDate);
                return null;
            }
        });
    }

    @Override
    public void delete(final String nodeName) {
        this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                sqlDao.delete(nodeName);
                return null;
            }
        });
    }

    @Override
    public List<NodeInfoModelDao> getAll() {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<NodeInfoModelDao>>(){

            public List<NodeInfoModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                return sqlDao.getAll();
            }
        });
    }

    @Override
    public NodeInfoModelDao getByNodeName(final String nodeName) {
        return (NodeInfoModelDao)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<NodeInfoModelDao>(){

            public NodeInfoModelDao inTransaction(Handle handle, TransactionStatus status) throws Exception {
                NodeInfoSqlDao sqlDao = (NodeInfoSqlDao)handle.attach(NodeInfoSqlDao.class);
                return sqlDao.getByNodeName(nodeName);
            }
        });
    }
}

