/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.api.PluginServiceInfo;
import org.killbill.billing.osgi.api.PluginState;
import org.killbill.billing.util.nodes.json.PluginServiceInfoModelJson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInfoModelJson {
    private final String bundleSymbolicName;
    private final String pluginKey;
    private final String pluginName;
    private final String version;
    private final PluginState state;
    private final Set<PluginServiceInfoModelJson> services;
    private final Boolean isSelectedForStart;

    @JsonCreator
    public PluginInfoModelJson(@JsonProperty(value="bundleSymbolicName") String bundleSymbolicName, @JsonProperty(value="pluginKey") String pluginKey, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="version") String version, @JsonProperty(value="state") PluginState state, @JsonProperty(value="isSelectedForStart") Boolean isSelectedForStart, @JsonProperty(value="services") Set<PluginServiceInfoModelJson> services) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.pluginKey = pluginKey;
        this.pluginName = pluginName;
        this.version = version;
        this.state = state;
        this.isSelectedForStart = isSelectedForStart;
        this.services = services;
    }

    public PluginInfoModelJson(PluginInfo input) {
        this(input.getBundleSymbolicName(), input.getPluginKey(), input.getPluginName(), input.getVersion(), input.getPluginState(), input.isSelectedForStart(), (Set<PluginServiceInfoModelJson>)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)input.getServices(), (Function)new Function<PluginServiceInfo, PluginServiceInfoModelJson>(){

            public PluginServiceInfoModelJson apply(PluginServiceInfo input) {
                return new PluginServiceInfoModelJson(input.getServiceTypeName(), input.getRegistrationName());
            }
        })));
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getVersion() {
        return this.version;
    }

    public PluginState getState() {
        return this.state;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    @JsonProperty(value="isSelectedForStart")
    public boolean isSelectedForStart() {
        return this.isSelectedForStart;
    }

    public Set<PluginServiceInfoModelJson> getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginInfoModelJson)) {
            return false;
        }
        PluginInfoModelJson that = (PluginInfoModelJson)o;
        if (this.bundleSymbolicName != null ? !this.bundleSymbolicName.equals(that.bundleSymbolicName) : that.bundleSymbolicName != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals((Object)that.state) : that.state != null) {
            return false;
        }
        if (this.isSelectedForStart != that.isSelectedForStart) {
            return false;
        }
        if (this.pluginKey != null ? !this.pluginKey.equals(that.pluginKey) : that.pluginKey != null) {
            return false;
        }
        if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.services == null ? that.services != null : !this.services.equals(that.services));
    }

    public int hashCode() {
        int result = this.bundleSymbolicName != null ? this.bundleSymbolicName.hashCode() : 0;
        result = 31 * result + (this.pluginKey != null ? this.pluginKey.hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
        return result;
    }
}

