/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.killbill.billing.callcontext.DefaultTenantContext;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.security.SecurityApiException;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.callcontext.TenantContext;

public class PermissionAnnotationHandler
extends AuthorizingAnnotationHandler {
    private final TenantContext context = new DefaultTenantContext(null);
    @Inject
    SecurityApi securityApi;

    public PermissionAnnotationHandler() {
        super(RequiresPermissions.class);
    }

    public void assertAuthorized(Annotation annotation) throws AuthorizationException {
        if (!(annotation instanceof RequiresPermissions)) {
            return;
        }
        RequiresPermissions requiresPermissions = (RequiresPermissions)annotation;
        try {
            this.securityApi.checkCurrentUserPermissions((List)ImmutableList.copyOf((Object[])requiresPermissions.value()), requiresPermissions.logical(), this.context);
        }
        catch (SecurityApiException e) {
            if (e.getCause() != null && e.getCause() instanceof AuthorizationException) {
                throw (AuthorizationException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new AuthorizationException(e.getCause());
            }
            throw new AuthorizationException((Throwable)e);
        }
    }
}

