/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.api;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.security.Logical;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.SecurityApiException;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.security.shiro.dao.RolesPermissionsModelDao;
import org.killbill.billing.util.security.shiro.dao.UserDao;
import org.killbill.billing.util.security.shiro.dao.UserRolesModelDao;
import org.killbill.billing.util.security.shiro.realm.KillBillJdbcRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecurityApi
implements SecurityApi {
    private static final String[] allPermissions = new String[Permission.values().length];
    private final UserDao userDao;

    @Inject
    public DefaultSecurityApi(UserDao userDao) {
        this.userDao = userDao;
    }

    public synchronized void login(final Object principal, final Object credentials) {
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            this.logout();
        }
        if (principal.equals(currentUser.getPrincipal()) && currentUser.isAuthenticated()) {
            return;
        }
        if (principal instanceof String && credentials instanceof String) {
            currentUser.login((AuthenticationToken)new UsernamePasswordToken((String)principal, (String)credentials));
        } else if (principal instanceof String && credentials instanceof char[]) {
            currentUser.login((AuthenticationToken)new UsernamePasswordToken((String)principal, (char[])credentials));
        } else {
            currentUser.login(new AuthenticationToken(){

                public Object getPrincipal() {
                    return principal;
                }

                public Object getCredentials() {
                    return credentials;
                }
            });
        }
    }

    public void logout() {
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser != null && currentUser.isAuthenticated()) {
            currentUser.logout();
        }
    }

    public boolean isSubjectAuthenticated() {
        return SecurityUtils.getSubject().isAuthenticated();
    }

    public Set<Permission> getCurrentUserPermissions(TenantContext context) {
        Permission[] killbillPermissions = Permission.values();
        String[] killbillPermissionsString = this.getAllPermissionsAsStrings();
        Subject subject = SecurityUtils.getSubject();
        boolean[] permissions = subject.isPermitted(killbillPermissionsString);
        HashSet<Permission> userPermissions = new HashSet<Permission>();
        for (int i = 0; i < permissions.length; ++i) {
            if (!permissions[i]) continue;
            userPermissions.add(killbillPermissions[i]);
        }
        return userPermissions;
    }

    public void checkCurrentUserPermissions(List<Permission> permissions, Logical logical, TenantContext context) throws SecurityApiException {
        String[] permissionsString = Lists.transform(permissions, (Function)Functions.toStringFunction()).toArray(new String[permissions.size()]);
        try {
            Subject subject = SecurityUtils.getSubject();
            if (permissionsString.length == 1) {
                subject.checkPermission(permissionsString[0]);
            } else if (Logical.AND.equals((Object)logical)) {
                subject.checkPermissions(permissionsString);
            } else if (Logical.OR.equals((Object)logical)) {
                boolean hasAtLeastOnePermission = false;
                for (String permission : permissionsString) {
                    if (!subject.isPermitted(permission)) continue;
                    hasAtLeastOnePermission = true;
                    break;
                }
                if (!hasAtLeastOnePermission) {
                    subject.checkPermission(permissionsString[0]);
                }
            }
        }
        catch (AuthorizationException e) {
            throw new SecurityApiException((Throwable)e, ErrorCode.SECURITY_NOT_ENOUGH_PERMISSIONS, new Object[0]);
        }
    }

    public void addUserRoles(String username, String password, List<String> roles, CallContext callContext) throws SecurityApiException {
        this.userDao.insertUser(username, password, roles, callContext.getUserName());
    }

    public void updateUserPassword(String username, String password, CallContext callContext) throws SecurityApiException {
        this.userDao.updateUserPassword(username, password, callContext.getUserName());
    }

    public void updateUserRoles(String username, List<String> roles, CallContext callContext) throws SecurityApiException {
        this.userDao.updateUserRoles(username, roles, callContext.getUserName());
        this.invalidateJDBCAuthorizationCache(username);
    }

    public void invalidateUser(String username, CallContext callContext) throws SecurityApiException {
        this.userDao.invalidateUser(username, callContext.getUserName());
    }

    public List<String> getUserRoles(String username, TenantContext tenantContext) {
        List<UserRolesModelDao> permissionsModelDao = this.userDao.getUserRoles(username);
        return ImmutableList.copyOf((Iterable)Iterables.transform(permissionsModelDao, (Function)new Function<UserRolesModelDao, String>(){

            @Nullable
            public String apply(UserRolesModelDao input) {
                return input.getRoleName();
            }
        }));
    }

    public void addRoleDefinition(String role, List<String> permissions, CallContext callContext) throws SecurityApiException {
        List<String> sanitizedPermissions = this.sanitizeAndValidatePermissions(permissions);
        this.userDao.addRoleDefinition(role, sanitizedPermissions, callContext.getUserName());
    }

    public List<String> getRoleDefinition(String role, TenantContext tenantContext) {
        List<RolesPermissionsModelDao> permissionsModelDao = this.userDao.getRoleDefinition(role);
        return ImmutableList.copyOf((Iterable)Iterables.transform(permissionsModelDao, (Function)new Function<RolesPermissionsModelDao, String>(){

            @Nullable
            public String apply(RolesPermissionsModelDao input) {
                return input.getPermission();
            }
        }));
    }

    private List<String> sanitizeAndValidatePermissions(List<String> permissionsRaw) throws SecurityApiException {
        if (permissionsRaw == null) {
            return ImmutableList.of();
        }
        Collection permissions = Collections2.filter((Collection)Lists.transform(permissionsRaw, (Function)new Function<String, String>(){

            public String apply(String input) {
                return Strings.emptyToNull((String)input);
            }
        }), (Predicate)Predicates.notNull());
        HashMap groupToValues = new HashMap();
        for (String curPerm : permissions) {
            if ("*".equals(curPerm)) {
                return ImmutableList.of((Object)"*");
            }
            String[] permissionParts = curPerm.split(":");
            if (permissionParts.length != 1 && permissionParts.length != 2) {
                throw new SecurityApiException(ErrorCode.SECURITY_INVALID_PERMISSIONS, new Object[]{curPerm});
            }
            boolean resolved = false;
            for (Permission cur : Permission.values()) {
                if (!cur.getGroup().equals(permissionParts[0])) continue;
                HashSet<String> groupPermissions = (HashSet<String>)groupToValues.get(permissionParts[0]);
                if (groupPermissions == null) {
                    groupPermissions = new HashSet<String>();
                    groupToValues.put(permissionParts[0], groupPermissions);
                }
                if (permissionParts.length == 1 || "*".equals(permissionParts[1])) {
                    groupPermissions.clear();
                    groupPermissions.add("*");
                    resolved = true;
                    break;
                }
                if (!cur.getValue().equals(permissionParts[1])) continue;
                groupPermissions.add(permissionParts[1]);
                resolved = true;
                break;
            }
            if (resolved) continue;
            throw new SecurityApiException(ErrorCode.SECURITY_INVALID_PERMISSIONS, new Object[]{curPerm});
        }
        ArrayList<String> sanitizedPermissions = new ArrayList<String>();
        for (String group : groupToValues.keySet()) {
            Set groupPermissions = (Set)groupToValues.get(group);
            for (String value : groupPermissions) {
                sanitizedPermissions.add(String.format("%s:%s", group, value));
            }
        }
        return sanitizedPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] getAllPermissionsAsStrings() {
        if (allPermissions[0] != null) return allPermissions;
        String[] stringArray = allPermissions;
        synchronized (allPermissions) {
            if (allPermissions[0] != null) return allPermissions;
            Permission[] killbillPermissions = Permission.values();
            for (int i = 0; i < killbillPermissions.length; ++i) {
                DefaultSecurityApi.allPermissions[i] = killbillPermissions[i].toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return allPermissions;
        }
    }

    private void invalidateJDBCAuthorizationCache(String username) {
        Collection realms = ((DefaultSecurityManager)SecurityUtils.getSecurityManager()).getRealms();
        KillBillJdbcRealm killBillJdbcRealm = (KillBillJdbcRealm)((Object)Iterables.tryFind((Iterable)realms, (Predicate)new Predicate<Realm>(){

            public boolean apply(@Nullable Realm input) {
                return input instanceof KillBillJdbcRealm;
            }
        }).orNull());
        if (killBillJdbcRealm != null) {
            SimplePrincipalCollection principals = new SimplePrincipalCollection();
            principals.add((Object)username, killBillJdbcRealm.getName());
            killBillJdbcRealm.clearCachedAuthorizationInfo((PrincipalCollection)principals);
        }
    }
}

