/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.api;

import javax.inject.Inject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.billing.util.security.api.SecurityService;

public class DefaultSecurityService
implements SecurityService {
    public static final String SECURITY_SERVICE_NAME = "security-service";
    private final SecurityManager securityManager;

    @Inject
    public DefaultSecurityService(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public String getName() {
        return SECURITY_SERVICE_NAME;
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public void initialize() {
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
    public void stop() {
        SecurityUtils.setSecurityManager(null);
    }
}

