/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.dao;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionSqlDao;
import org.killbill.billing.util.security.shiro.dao.SessionModelDao;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSessionDao
extends CachingSessionDAO {
    private static final Logger log = LoggerFactory.getLogger(JDBCSessionDao.class);
    private final JDBCSessionSqlDao jdbcSessionSqlDao;
    private final Cache<Serializable, Boolean> noUpdateSessionsCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();

    @Inject
    public JDBCSessionDao(IDBI dbi) {
        this.jdbcSessionSqlDao = (JDBCSessionSqlDao)dbi.onDemand(JDBCSessionSqlDao.class);
    }

    protected void doUpdate(Session session) {
        if (this.shouldUpdateSession(session)) {
            this.jdbcSessionSqlDao.update(new SessionModelDao(session));
        }
    }

    protected void doDelete(Session session) {
        this.jdbcSessionSqlDao.delete(new SessionModelDao(session));
    }

    protected Serializable doCreate(Session session) {
        UUID sessionId = UUIDs.randomUUID();
        String sessionIdAsString = sessionId.toString();
        this.assignSessionId(session, (Serializable)((Object)sessionIdAsString));
        this.jdbcSessionSqlDao.create(new SessionModelDao(session));
        return sessionIdAsString;
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            return null;
        }
        String sessionIdString = sessionId.toString();
        SessionModelDao sessionModelDao = this.jdbcSessionSqlDao.read(sessionIdString);
        if (sessionModelDao == null) {
            return null;
        }
        try {
            return sessionModelDao.toSimpleSession();
        }
        catch (IOException e) {
            log.warn("Corrupted cookie", (Throwable)e);
            return null;
        }
    }

    public void disableUpdatesForSession(Session session) {
        this.noUpdateSessionsCache.put((Object)session.getId(), (Object)Boolean.TRUE);
    }

    public void enableUpdatesForSession(Session session) {
        this.noUpdateSessionsCache.invalidate((Object)session.getId());
        this.doUpdate(session);
    }

    private boolean shouldUpdateSession(Session session) {
        return this.noUpdateSessionsCache.getIfPresent((Object)session.getId()) == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE;
    }
}

