/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.security.shiro.KillbillCredentialsMatcher;

public class KillBillJdbcRealm
extends JdbcRealm {
    protected static final String KILLBILL_SALTED_AUTHENTICATION_QUERY = "select password, password_salt from users where username = ? and is_active";
    protected static final String KILLBILL_USER_ROLES_QUERY = "select role_name from user_roles where username = ? and is_active";
    protected static final String KILLBILL_PERMISSIONS_QUERY = "select permission from roles_permissions where role_name = ? and is_active";
    private final DataSource dataSource;
    private final SecurityConfig securityConfig;

    @Inject
    public KillBillJdbcRealm(@Named(value="shiro") DataSource dataSource, SecurityConfig securityConfig) {
        this.dataSource = dataSource;
        this.securityConfig = securityConfig;
        this.setPermissionsLookupEnabled(true);
        this.setAuthenticationQuery(KILLBILL_SALTED_AUTHENTICATION_QUERY);
        this.setUserRolesQuery(KILLBILL_USER_ROLES_QUERY);
        this.setPermissionsQuery(KILLBILL_PERMISSIONS_QUERY);
        this.configureSecurity();
        this.configureDataSource();
    }

    public void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        super.clearCachedAuthorizationInfo(principals);
    }

    private void configureSecurity() {
        this.setSaltStyle(JdbcRealm.SaltStyle.COLUMN);
        this.setCredentialsMatcher(KillbillCredentialsMatcher.getCredentialsMatcher(this.securityConfig));
    }

    private void configureDataSource() {
        this.setDataSource(this.dataSource);
    }
}

