/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.security.shiro.realm.SkipSSLCheckSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillJndiLdapRealm
extends JndiLdapRealm {
    private static final Logger log = LoggerFactory.getLogger(KillBillJndiLdapRealm.class);
    private static final String USERDN_SUBSTITUTION_TOKEN = "{0}";
    private static final SearchControls SUBTREE_SCOPE = new SearchControls();
    private static final Splitter SPLITTER;
    private final String searchBase;
    private final String groupSearchFilter;
    private final String groupNameId;
    private final Map<String, Collection<String>> permissionsByGroup = Maps.newLinkedHashMap();
    private final String dnSearchFilter;

    @Inject
    public KillBillJndiLdapRealm(SecurityConfig securityConfig) {
        if (securityConfig.getShiroLDAPUserDnTemplate() != null) {
            this.setUserDnTemplate(securityConfig.getShiroLDAPUserDnTemplate());
        }
        JndiLdapContextFactory contextFactory = (JndiLdapContextFactory)this.getContextFactory();
        if (securityConfig.disableShiroLDAPSSLCheck()) {
            contextFactory.getEnvironment().put("java.naming.ldap.factory.socket", SkipSSLCheckSocketFactory.class.getName());
        }
        contextFactory.getEnvironment().put("java.naming.referral", securityConfig.followShiroLDAPReferrals() ? "follow" : "ignore");
        if (securityConfig.getShiroLDAPUrl() != null) {
            contextFactory.setUrl(securityConfig.getShiroLDAPUrl());
        }
        if (securityConfig.getShiroLDAPSystemUsername() != null) {
            contextFactory.setSystemUsername(securityConfig.getShiroLDAPSystemUsername());
        }
        if (securityConfig.getShiroLDAPSystemPassword() != null) {
            contextFactory.setSystemPassword(securityConfig.getShiroLDAPSystemPassword());
        }
        if (securityConfig.getShiroLDAPAuthenticationMechanism() != null) {
            contextFactory.setAuthenticationMechanism(securityConfig.getShiroLDAPAuthenticationMechanism());
        }
        this.setContextFactory((LdapContextFactory)contextFactory);
        this.dnSearchFilter = securityConfig.getShiroLDAPDnSearchTemplate();
        this.searchBase = securityConfig.getShiroLDAPSearchBase();
        this.groupSearchFilter = securityConfig.getShiroLDAPGroupSearchFilter();
        this.groupNameId = securityConfig.getShiroLDAPGroupNameID();
        if (securityConfig.getShiroLDAPPermissionsByGroup() != null) {
            Ini ini = new Ini();
            ini.load(securityConfig.getShiroLDAPPermissionsByGroup().replace("\\n", "\n"));
            for (Ini.Section section : ini.getSections()) {
                for (String rawRole : section.keySet()) {
                    ImmutableList permissions = ImmutableList.copyOf((Iterable)SPLITTER.split((CharSequence)section.get((Object)rawRole)));
                    String role = rawRole.replace("\\=", "=");
                    this.permissionsByGroup.put(role, (Collection<String>)permissions);
                }
            }
        }
    }

    protected String getUserDn(String principal) throws IllegalArgumentException, IllegalStateException {
        if (this.dnSearchFilter != null) {
            return this.findUserDN(principal, this.getContextFactory());
        }
        return super.getUserDn(principal);
    }

    private String findUserDN(String userName, LdapContextFactory ldapContextFactory) {
        LdapContext systemLdapCtx = null;
        try {
            systemLdapCtx = ldapContextFactory.getSystemLdapContext();
            NamingEnumeration<SearchResult> usersFound = systemLdapCtx.search(this.searchBase, this.dnSearchFilter.replace(USERDN_SUBSTITUTION_TOKEN, userName), SUBTREE_SCOPE);
            String string = usersFound.hasMore() ? usersFound.next().getNameInNamespace() : null;
            return string;
        }
        catch (AuthenticationException ex) {
            log.info("LDAP authentication exception='{}'", (Object)ex.getLocalizedMessage());
            throw new IllegalArgumentException(ex);
        }
        catch (NamingException e) {
            log.info("LDAP exception='{}'", (Object)e.getLocalizedMessage());
            throw new IllegalArgumentException(e);
        }
        finally {
            LdapUtils.closeContext((LdapContext)systemLdapCtx);
        }
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        Set<String> userGroups = this.findLDAPGroupsForUser(principals, ldapContextFactory);
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo(userGroups);
        Set<String> stringPermissions = this.groupsPermissions(userGroups);
        simpleAuthorizationInfo.setStringPermissions(stringPermissions);
        return simpleAuthorizationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findLDAPGroupsForUser(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext systemLdapCtx = null;
        try {
            systemLdapCtx = ldapContextFactory.getSystemLdapContext();
            Set<String> set = this.findLDAPGroupsForUser(username, systemLdapCtx);
            return set;
        }
        catch (AuthenticationException ex) {
            log.info("LDAP authentication exception='{}'", (Object)ex.getLocalizedMessage());
            ImmutableSet immutableSet = ImmutableSet.of();
            return immutableSet;
        }
        finally {
            LdapUtils.closeContext((LdapContext)systemLdapCtx);
        }
    }

    private Set<String> findLDAPGroupsForUser(String userName, LdapContext ldapCtx) throws NamingException {
        NamingEnumeration<SearchResult> foundGroups = ldapCtx.search(this.searchBase, this.groupSearchFilter.replace(USERDN_SUBSTITUTION_TOKEN, userName), SUBTREE_SCOPE);
        if (!foundGroups.hasMoreElements()) {
            return ImmutableSet.of();
        }
        SearchResult result = foundGroups.next();
        Collection finalGroupsNames = Collections2.filter(this.extractGroupNamesFromSearchResult(result), (Predicate)Predicates.notNull());
        return Sets.newHashSet((Iterable)finalGroupsNames);
    }

    private Collection<String> extractGroupNamesFromSearchResult(SearchResult searchResult) {
        UnmodifiableIterator attributesIterator = Iterators.forEnumeration(searchResult.getAttributes().getAll());
        UnmodifiableIterator groupNameAttributesIterator = Iterators.filter((Iterator)attributesIterator, (Predicate)new Predicate<Attribute>(){

            public boolean apply(Attribute attribute) {
                return KillBillJndiLdapRealm.this.groupNameId.equalsIgnoreCase(attribute.getID());
            }
        });
        Iterator groupNamesIterator = Iterators.transform((Iterator)groupNameAttributesIterator, (Function)new Function<Attribute, Iterator<?>>(){

            public Iterator<?> apply(Attribute groupNameAttribute) {
                try {
                    NamingEnumeration<?> enumeration = groupNameAttribute.getAll();
                    return Iterators.forEnumeration(enumeration);
                }
                catch (NamingException namingException) {
                    log.warn("Unable to read group name(s)", (Throwable)namingException);
                    return null;
                }
            }
        });
        UnmodifiableIterator finalGroupNamesIterator = Iterators.filter((Iterator)Iterators.concat((Iterator)groupNamesIterator), (Predicate)Predicates.notNull());
        return ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)finalGroupNamesIterator, (Function)Functions.toStringFunction()));
    }

    private Set<String> groupsPermissions(Set<String> groups) {
        HashSet<String> permissions = new HashSet<String>();
        for (String group : groups) {
            Collection<String> permissionsForGroup = this.permissionsByGroup.get(group);
            if (permissionsForGroup == null) continue;
            permissions.addAll(permissionsForGroup);
        }
        return permissions;
    }

    @VisibleForTesting
    public Map<String, Collection<String>> getPermissionsByGroup() {
        return this.permissionsByGroup;
    }

    static {
        SUBTREE_SCOPE.setSearchScope(2);
        SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    }
}

