/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillOktaRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(KillBillOktaRealm.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final int DEFAULT_TIMEOUT_SECS = 15;
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final Map<String, Collection<String>> permissionsByGroup = Maps.newLinkedHashMap();
    private final SecurityConfig securityConfig;
    private final AsyncHttpClient httpClient;

    @Inject
    public KillBillOktaRealm(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        this.httpClient = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(15000).build());
        if (securityConfig.getShiroOktaPermissionsByGroup() != null) {
            Ini ini = new Ini();
            ini.load(securityConfig.getShiroOktaPermissionsByGroup().replace("\\n", "\n"));
            for (Ini.Section section : ini.getSections()) {
                for (String role : section.keySet()) {
                    ImmutableList permissions = ImmutableList.copyOf((Iterable)SPLITTER.split((CharSequence)section.get((Object)role)));
                    this.permissionsByGroup.put(role, (Collection<String>)permissions);
                }
            }
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String username = (String)this.getAvailablePrincipal(principals);
        String userId = this.findOktaUserId(username);
        Set<String> userGroups = this.findOktaGroupsForUser(userId);
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo(userGroups);
        Set<String> stringPermissions = this.groupsPermissions(userGroups);
        simpleAuthorizationInfo.setStringPermissions(stringPermissions);
        return simpleAuthorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        if (this.doAuthenticate(upToken)) {
            return new SimpleAuthenticationInfo(token.getPrincipal(), token.getCredentials(), this.getName());
        }
        throw new AuthenticationException("Okta authentication failed");
    }

    private boolean doAuthenticate(UsernamePasswordToken upToken) {
        Response response;
        AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.preparePost(this.securityConfig.getShiroOktaUrl() + "/api/v1/authn");
        try {
            ImmutableMap body = ImmutableMap.of((Object)"username", (Object)upToken.getUsername(), (Object)"password", (Object)String.valueOf(upToken.getPassword()));
            builder.setBody(mapper.writeValueAsString((Object)body));
        }
        catch (JsonProcessingException e) {
            log.warn("Error while generating Okta payload");
            throw new AuthenticationException((Throwable)e);
        }
        builder.addHeader("Authorization", "SSWS " + this.securityConfig.getShiroOktaAPIToken());
        builder.addHeader("Content-Type", "application/json; charset=UTF-8");
        try {
            ListenableFuture futureStatus = builder.execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            response = (Response)futureStatus.get(15L, TimeUnit.SECONDS);
        }
        catch (TimeoutException toe) {
            log.warn("Timeout while connecting to Okta");
            throw new AuthenticationException((Throwable)toe);
        }
        catch (Exception e) {
            log.warn("Error while connecting to Okta");
            throw new AuthenticationException((Throwable)e);
        }
        return this.isAuthenticated(response);
    }

    private boolean isAuthenticated(Response oktaRawResponse) {
        try {
            Map oktaResponse = (Map)mapper.readValue(oktaRawResponse.getResponseBodyAsStream(), Map.class);
            if ("SUCCESS".equals(oktaResponse.get("status"))) {
                return true;
            }
            log.warn("Okta authentication failed: " + oktaResponse);
            return false;
        }
        catch (IOException e) {
            log.warn("Unable to read response from Okta");
            throw new AuthenticationException((Throwable)e);
        }
    }

    private String findOktaUserId(String login) {
        String path;
        try {
            path = "/api/v1/users/" + URLEncoder.encode(login, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        Response oktaRawResponse = this.doGetRequest(path);
        try {
            Map oktaResponse = (Map)mapper.readValue(oktaRawResponse.getResponseBodyAsStream(), Map.class);
            return (String)oktaResponse.get("id");
        }
        catch (IOException e) {
            log.warn("Unable to read response from Okta");
            throw new AuthorizationException((Throwable)e);
        }
    }

    private Set<String> findOktaGroupsForUser(String userId) {
        String path = "/api/v1/users/" + userId + "/groups";
        Response response = this.doGetRequest(path);
        return this.getGroups(response);
    }

    private Response doGetRequest(String path) {
        Response response;
        AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.prepareGet(this.securityConfig.getShiroOktaUrl() + path);
        builder.addHeader("Authorization", "SSWS " + this.securityConfig.getShiroOktaAPIToken());
        builder.addHeader("Content-Type", "application/json; charset=UTF-8");
        try {
            ListenableFuture futureStatus = builder.execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            response = (Response)futureStatus.get(15L, TimeUnit.SECONDS);
        }
        catch (TimeoutException toe) {
            log.warn("Timeout while connecting to Okta");
            throw new AuthorizationException((Throwable)toe);
        }
        catch (Exception e) {
            log.warn("Error while connecting to Okta");
            throw new AuthorizationException((Throwable)e);
        }
        return response;
    }

    private Set<String> getGroups(Response oktaRawResponse) {
        try {
            List oktaResponse = (List)mapper.readValue(oktaRawResponse.getResponseBodyAsStream(), (TypeReference)new TypeReference<List<Map>>(){});
            HashSet<String> groups = new HashSet<String>();
            for (Map group : oktaResponse) {
                Object groupProfile = group.get("profile");
                if (groupProfile == null || !(groupProfile instanceof Map)) continue;
                groups.add((String)((Map)groupProfile).get("name"));
            }
            return groups;
        }
        catch (IOException e) {
            log.warn("Unable to read response from Okta");
            throw new AuthorizationException((Throwable)e);
        }
    }

    private Set<String> groupsPermissions(Iterable<String> groups) {
        HashSet<String> permissions = new HashSet<String>();
        for (String group : groups) {
            Collection<String> permissionsForGroup = this.permissionsByGroup.get(group);
            if (permissionsForGroup == null) continue;
            permissions.addAll(permissionsForGroup);
        }
        return permissions;
    }
}

