/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipSSLCheckSocketFactory
extends SocketFactory {
    private static final Logger log = LoggerFactory.getLogger(SkipSSLCheckSocketFactory.class);
    private static SocketFactory skipSSLCheckFactory = null;

    public static SocketFactory getDefault() {
        return new SkipSSLCheckSocketFactory();
    }

    public Socket createSocket(String arg0, int arg1) throws IOException {
        return skipSSLCheckFactory.createSocket(arg0, arg1);
    }

    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return skipSSLCheckFactory.createSocket(arg0, arg1);
    }

    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return skipSSLCheckFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return skipSSLCheckFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    static {
        TrustManager[] noOpTrustManagers = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] c, String a) {
            }

            public void checkServerTrusted(X509Certificate[] c, String a) {
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, noOpTrustManagers, new SecureRandom());
            skipSSLCheckFactory = context.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            log.warn("SSL exception", (Throwable)e);
        }
    }
}

