/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTagDefinition
extends EntityBase
implements TagDefinition {
    private final String name;
    private final String description;
    private final Boolean controlTag;
    private final List<ObjectType> applicableObjectTypes;

    public DefaultTagDefinition(TagDefinitionModelDao tagDefinitionModelDao, boolean isControlTag) {
        this(tagDefinitionModelDao.getId(), tagDefinitionModelDao.getName(), tagDefinitionModelDao.getDescription(), isControlTag);
    }

    public DefaultTagDefinition(String name, String description, Boolean isControlTag) {
        this(UUIDs.randomUUID(), name, description, isControlTag);
    }

    public DefaultTagDefinition(UUID id, String name, String description, Boolean isControlTag) {
        this(id, name, description, isControlTag, DefaultTagDefinition.getApplicableObjectTypes(id, isControlTag));
    }

    public DefaultTagDefinition(ControlTagType controlTag) {
        this(controlTag.getId(), controlTag.toString(), controlTag.getDescription(), true, controlTag.getApplicableObjectTypes());
    }

    @JsonCreator
    public DefaultTagDefinition(@JsonProperty(value="id") UUID id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="controlTag") Boolean controlTag, @JsonProperty(value="applicableObjectTypes") List<ObjectType> applicableObjectTypes) {
        super(id);
        this.name = name;
        this.description = description;
        this.controlTag = controlTag;
        this.applicableObjectTypes = applicableObjectTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isControlTag() {
        return this.controlTag;
    }

    public List<ObjectType> getApplicableObjectTypes() {
        return this.applicableObjectTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultTagDefinition");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", controlTag=").append(this.controlTag);
        sb.append(", applicableObjectTypes=").append(this.applicableObjectTypes);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultTagDefinition that = (DefaultTagDefinition)((Object)o);
        if (this.applicableObjectTypes != null ? !this.applicableObjectTypes.equals(that.applicableObjectTypes) : that.applicableObjectTypes != null) {
            return false;
        }
        if (this.controlTag != null ? !this.controlTag.equals(that.controlTag) : that.controlTag != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.controlTag != null ? this.controlTag.hashCode() : 0);
        result = 31 * result + (this.applicableObjectTypes != null ? this.applicableObjectTypes.hashCode() : 0);
        return result;
    }

    private static List<ObjectType> getApplicableObjectTypes(UUID id, Boolean isControlTag) {
        if (!isControlTag.booleanValue()) {
            return ImmutableList.copyOf((Object[])ObjectType.values());
        }
        for (ControlTagType cur : ControlTagType.values()) {
            if (!cur.getId().equals(id)) continue;
            return cur.getApplicableObjectTypes();
        }
        throw new IllegalStateException(String.format("ControlTag id %s does not seem to exist", id));
    }
}

