/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DefaultControlTag;
import org.killbill.billing.util.tag.DefaultTagDefinition;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.billing.util.tag.dao.TagDefinitionDao;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.killbill.billing.util.tag.dao.TagModelDaoHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTagInternalApi
implements TagInternalApi {
    private final TagDao tagDao;
    private final TagDefinitionDao tagDefinitionDao;

    @Inject
    public DefaultTagInternalApi(TagDao tagDao, TagDefinitionDao tagDefinitionDao) {
        this.tagDao = tagDao;
        this.tagDefinitionDao = tagDefinitionDao;
    }

    public List<TagDefinition> getTagDefinitions(InternalTenantContext context) {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.tagDefinitionDao.getTagDefinitions(true, context), (Function)new Function<TagDefinitionModelDao, TagDefinition>(){

            public TagDefinition apply(TagDefinitionModelDao input) {
                return new DefaultTagDefinition(input, TagModelDaoHelper.isControlTag(input.getName()));
            }
        }));
    }

    public List<Tag> getTags(UUID objectId, ObjectType objectType, InternalTenantContext context) {
        return this.toTagList(this.tagDao.getTagsForObject(objectId, objectType, false, context));
    }

    public List<Tag> getTagsForAccountType(ObjectType objectType, boolean includedDeleted, InternalTenantContext internalTenantContext) {
        return this.toTagList(this.tagDao.getTagsForAccountType(objectType, includedDeleted, internalTenantContext));
    }

    public void addTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, InternalCallContext context) throws TagApiException {
        TagModelDao tag = new TagModelDao(context.getCreatedDate(), tagDefinitionId, objectId, objectType);
        this.tagDao.create(tag, context);
    }

    public void removeTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, InternalCallContext context) throws TagApiException {
        this.tagDao.deleteTag(objectId, objectType, tagDefinitionId, context);
    }

    private List<Tag> toTagList(List<TagModelDao> input) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(input, (Function)new Function<TagModelDao, Tag>(){

            public Tag apply(TagModelDao input) {
                return TagModelDaoHelper.isControlTag(input.getTagDefinitionId()) ? new DefaultControlTag(ControlTagType.getTypeFromId((UUID)input.getTagDefinitionId()), input.getObjectType(), input.getObjectId(), input.getCreatedDate()) : new DescriptiveTag(input.getTagDefinitionId(), input.getObjectType(), input.getObjectId(), input.getCreatedDate());
            }
        }));
    }
}

