/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationHelper;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DefaultControlTag;
import org.killbill.billing.util.tag.DefaultTagDefinition;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.billing.util.tag.dao.SystemTags;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.billing.util.tag.dao.TagDefinitionDao;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.killbill.billing.util.tag.dao.TagModelDaoHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTagUserApi
implements TagUserApi {
    private static final Function<TagModelDao, Tag> TAG_MODEL_DAO_TAG_FUNCTION = new Function<TagModelDao, Tag>(){

        public Tag apply(TagModelDao input) {
            return TagModelDaoHelper.isControlTag(input.getTagDefinitionId()) ? new DefaultControlTag(input.getId(), ControlTagType.getTypeFromId((UUID)input.getTagDefinitionId()), input.getObjectType(), input.getObjectId(), input.getCreatedDate()) : new DescriptiveTag(input.getId(), input.getTagDefinitionId(), input.getObjectType(), input.getObjectId(), input.getCreatedDate());
        }
    };
    private final InternalCallContextFactory internalCallContextFactory;
    private final TagDefinitionDao tagDefinitionDao;
    private final TagDao tagDao;

    @Inject
    public DefaultTagUserApi(InternalCallContextFactory internalCallContextFactory, TagDefinitionDao tagDefinitionDao, TagDao tagDao) {
        this.internalCallContextFactory = internalCallContextFactory;
        this.tagDefinitionDao = tagDefinitionDao;
        this.tagDao = tagDao;
    }

    public List<TagDefinition> getTagDefinitions(TenantContext context) {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.tagDefinitionDao.getTagDefinitions(true, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)), (Function)new Function<TagDefinitionModelDao, TagDefinition>(){

            public TagDefinition apply(TagDefinitionModelDao input) {
                return new DefaultTagDefinition(input, TagModelDaoHelper.isControlTag(input.getName()));
            }
        }));
    }

    public TagDefinition createTagDefinition(String definitionName, String description, CallContext context) throws TagDefinitionApiException {
        if (definitionName.matches(".*[A-Z].*")) {
            throw new TagDefinitionApiException(ErrorCode.TAG_DEFINITION_HAS_UPPERCASE, new Object[]{definitionName});
        }
        TagDefinitionModelDao tagDefinitionModelDao = this.tagDefinitionDao.create(definitionName, description, this.internalCallContextFactory.createInternalCallContextWithoutAccountRecordId(context));
        return new DefaultTagDefinition(tagDefinitionModelDao, TagModelDaoHelper.isControlTag(tagDefinitionModelDao.getName()));
    }

    public void deleteTagDefinition(UUID definitionId, CallContext context) throws TagDefinitionApiException {
        this.tagDefinitionDao.deleteById(definitionId, this.internalCallContextFactory.createInternalCallContextWithoutAccountRecordId(context));
    }

    public TagDefinition getTagDefinition(UUID tagDefinitionId, TenantContext context) throws TagDefinitionApiException {
        TagDefinitionModelDao tagDefinitionModelDao = (TagDefinitionModelDao)this.tagDefinitionDao.getById(tagDefinitionId, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
        return new DefaultTagDefinition(tagDefinitionModelDao, TagModelDaoHelper.isControlTag(tagDefinitionModelDao.getName()));
    }

    public List<TagDefinition> getTagDefinitions(Collection<UUID> tagDefinitionIds, TenantContext context) throws TagDefinitionApiException {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.tagDefinitionDao.getByIds(tagDefinitionIds, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)), (Function)new Function<TagDefinitionModelDao, TagDefinition>(){

            public TagDefinition apply(TagDefinitionModelDao input) {
                return new DefaultTagDefinition(input, TagModelDaoHelper.isControlTag(input.getName()));
            }
        }));
    }

    public void addTags(UUID objectId, ObjectType objectType, Collection<UUID> tagDefinitionIds, CallContext context) throws TagApiException {
        for (UUID tagDefinitionId : tagDefinitionIds) {
            this.addTag(objectId, objectType, tagDefinitionId, context);
        }
    }

    public void addTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, CallContext context) throws TagApiException {
        block3: {
            if (SystemTags.isSystemTag(tagDefinitionId)) {
                throw new IllegalStateException(String.format("Failed to add tag for tagDefinitionId='%s': System tags are reserved for the system.", tagDefinitionId));
            }
            InternalCallContext internalContext = this.internalCallContextFactory.createInternalCallContext(objectId, objectType, context);
            TagModelDao tag = new TagModelDao(context.getCreatedDate(), tagDefinitionId, objectId, objectType);
            try {
                this.tagDao.create(tag, internalContext);
            }
            catch (TagApiException e) {
                if (ErrorCode.TAG_ALREADY_EXISTS.getCode() == e.getCode()) break block3;
                throw e;
            }
        }
    }

    public void removeTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, CallContext context) throws TagApiException {
        this.tagDao.deleteTag(objectId, objectType, tagDefinitionId, this.internalCallContextFactory.createInternalCallContext(objectId, objectType, context));
    }

    public Pagination<Tag> searchTags(final String searchKey, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<TagModelDao, TagApiException>(){

            @Override
            public Pagination<TagModelDao> build() {
                return DefaultTagUserApi.this.tagDao.searchTags(searchKey, offset, limit, DefaultTagUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, TAG_MODEL_DAO_TAG_FUNCTION);
    }

    public Pagination<Tag> getTags(final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<TagModelDao, TagApiException>(){

            @Override
            public Pagination<TagModelDao> build() {
                return DefaultTagUserApi.this.tagDao.get(offset, limit, DefaultTagUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, TAG_MODEL_DAO_TAG_FUNCTION);
    }

    public void removeTags(UUID objectId, ObjectType objectType, Collection<UUID> tagDefinitionIds, CallContext context) throws TagApiException {
        for (UUID tagDefinitionId : tagDefinitionIds) {
            this.tagDao.deleteTag(objectId, objectType, tagDefinitionId, this.internalCallContextFactory.createInternalCallContext(objectId, objectType, context));
        }
    }

    public TagDefinition getTagDefinitionForName(String tagDefinitionName, TenantContext context) throws TagDefinitionApiException {
        return new DefaultTagDefinition(this.tagDefinitionDao.getByName(tagDefinitionName, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)), TagModelDaoHelper.isControlTag(tagDefinitionName));
    }

    public List<Tag> getTagsForObject(UUID objectId, ObjectType objectType, boolean includedDeleted, TenantContext context) {
        return this.withModelTransform(this.tagDao.getTagsForObject(objectId, objectType, includedDeleted, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)));
    }

    public List<Tag> getTagsForAccountType(UUID accountId, ObjectType objectType, boolean includedDeleted, TenantContext context) {
        return this.withModelTransform(this.tagDao.getTagsForAccountType(objectType, includedDeleted, this.internalCallContextFactory.createInternalTenantContext(accountId, context)));
    }

    public List<Tag> getTagsForAccount(UUID accountId, boolean includedDeleted, TenantContext context) {
        return this.withModelTransform(this.tagDao.getTagsForAccount(includedDeleted, this.internalCallContextFactory.createInternalTenantContext(accountId, context)));
    }

    private List<Tag> withModelTransform(Collection<TagModelDao> input) {
        return ImmutableList.copyOf((Collection)Collections2.transform(input, TAG_MODEL_DAO_TAG_FUNCTION));
    }
}

