/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.events.UserTagDeletionInternalEvent;
import org.killbill.billing.util.tag.TagDefinition;

public class DefaultUserTagDeletionEvent
extends BusEventBase
implements UserTagDeletionInternalEvent {
    private final UUID tagId;
    private final UUID objectId;
    private final ObjectType objectType;
    private final TagDefinition tagDefinition;

    @JsonCreator
    public DefaultUserTagDeletionEvent(@JsonProperty(value="tagId") UUID tagId, @JsonProperty(value="objectId") UUID objectId, @JsonProperty(value="objectType") ObjectType objectType, @JsonProperty(value="tagDefinition") TagDefinition tagDefinition, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
        super(searchKey1, searchKey2, userToken);
        this.tagId = tagId;
        this.objectId = objectId;
        this.objectType = objectType;
        this.tagDefinition = tagDefinition;
    }

    public UUID getTagId() {
        return this.tagId;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public TagDefinition getTagDefinition() {
        return this.tagDefinition;
    }

    @JsonIgnore
    public BusInternalEvent.BusInternalEventType getBusEventType() {
        return BusInternalEvent.BusInternalEventType.USER_TAG_DELETION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultUserTagDeletionEvent");
        sb.append("{objectId=").append(this.objectId);
        sb.append(", tagId=").append(this.tagId);
        sb.append(", objectType=").append(this.objectType);
        sb.append(", tagDefinition=").append(this.tagDefinition);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultUserTagDeletionEvent that = (DefaultUserTagDeletionEvent)((Object)o);
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        if (this.tagDefinition != null ? !this.tagDefinition.equals(that.tagDefinition) : that.tagDefinition != null) {
            return false;
        }
        return !(this.tagId != null ? !this.tagId.equals(that.tagId) : that.tagId != null);
    }

    public int hashCode() {
        int result = this.tagId != null ? this.tagId.hashCode() : 0;
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.tagDefinition != null ? this.tagDefinition.hashCode() : 0);
        return result;
    }
}

