/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.events.ControlTagDefinitionCreationInternalEvent;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.EntityDaoBase;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.billing.util.tag.api.user.TagEventBuilder;
import org.killbill.billing.util.tag.dao.SystemTags;
import org.killbill.billing.util.tag.dao.TagDefinitionDao;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagDefinitionSqlDao;
import org.killbill.billing.util.tag.dao.TagModelDaoHelper;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTagDefinitionDao
extends EntityDaoBase<TagDefinitionModelDao, TagDefinition, TagDefinitionApiException>
implements TagDefinitionDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultTagDefinitionDao.class);
    private final TagEventBuilder tagEventBuilder;
    private final PersistentBus bus;

    @Inject
    public DefaultTagDefinitionDao(IDBI dbi, TagEventBuilder tagEventBuilder, PersistentBus bus, Clock clock, CacheControllerDispatcher controllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        super(new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, controllerDispatcher, nonEntityDao, internalCallContextFactory), TagDefinitionSqlDao.class);
        this.tagEventBuilder = tagEventBuilder;
        this.bus = bus;
    }

    @Override
    public List<TagDefinitionModelDao> getTagDefinitions(final boolean includeSystemTags, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<List<TagDefinitionModelDao>>(){

            @Override
            public List<TagDefinitionModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                TagDefinitionSqlDao tagDefinitionSqlDao = entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class);
                Iterator all = tagDefinitionSqlDao.getAll(context);
                LinkedList<TagDefinitionModelDao> definitionList = new LinkedList<TagDefinitionModelDao>();
                Iterators.addAll(definitionList, all);
                definitionList.addAll(SystemTags.get(includeSystemTags));
                return definitionList;
            }
        });
    }

    @Override
    public TagDefinitionModelDao getByName(final String definitionName, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<TagDefinitionModelDao>(){

            @Override
            public TagDefinitionModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                TagDefinitionModelDao tagDefinitionModelDao = SystemTags.lookup(definitionName);
                return tagDefinitionModelDao != null ? tagDefinitionModelDao : entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class).getByName(definitionName, context);
            }
        });
    }

    @Override
    public TagDefinitionModelDao getById(final UUID definitionId, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<TagDefinitionModelDao>(){

            @Override
            public TagDefinitionModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                TagDefinitionModelDao tagDefinitionModelDao = SystemTags.lookup(definitionId);
                return tagDefinitionModelDao != null ? tagDefinitionModelDao : (TagDefinitionModelDao)entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class).getById(definitionId.toString(), context);
            }
        });
    }

    @Override
    public List<TagDefinitionModelDao> getByIds(final Collection<UUID> definitionIds, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<List<TagDefinitionModelDao>>(){

            @Override
            public List<TagDefinitionModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                LinkedList<TagDefinitionModelDao> result = new LinkedList<TagDefinitionModelDao>();
                for (UUID cur : definitionIds) {
                    TagDefinitionModelDao tagDefinitionModelDao = SystemTags.lookup(cur);
                    if (tagDefinitionModelDao == null) continue;
                    result.add(tagDefinitionModelDao);
                }
                if (definitionIds.size() > 0) {
                    result.addAll(entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class).getByIds(Collections2.transform((Collection)definitionIds, (Function)new Function<UUID, String>(){

                        public String apply(UUID input) {
                            return input.toString();
                        }
                    }), context));
                }
                return result;
            }
        });
    }

    @Override
    public TagDefinitionModelDao create(final String definitionName, final String description, final InternalCallContext context) throws TagDefinitionApiException {
        if (TagModelDaoHelper.isControlTag(definitionName)) {
            throw new TagDefinitionApiException(ErrorCode.TAG_DEFINITION_CONFLICTS_WITH_CONTROL_TAG, new Object[]{definitionName});
        }
        try {
            return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<TagDefinitionModelDao>(){

                @Override
                public TagDefinitionModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                    TagDefinitionSqlDao tagDefinitionSqlDao = entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class);
                    TagDefinitionModelDao existingDefinition = tagDefinitionSqlDao.getByName(definitionName, (InternalTenantContext)context);
                    if (existingDefinition != null) {
                        throw new TagDefinitionApiException(ErrorCode.TAG_DEFINITION_ALREADY_EXISTS, new Object[]{definitionName});
                    }
                    TagDefinitionModelDao tagDefinition = new TagDefinitionModelDao(context.getCreatedDate(), definitionName, description);
                    DefaultTagDefinitionDao.this.createAndRefresh(tagDefinitionSqlDao, tagDefinition, context);
                    boolean isControlTag = TagModelDaoHelper.isControlTag(tagDefinition.getName());
                    Object tagDefinitionEvent = isControlTag ? DefaultTagDefinitionDao.this.tagEventBuilder.newControlTagDefinitionCreationEvent(tagDefinition.getId(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()) : DefaultTagDefinitionDao.this.tagEventBuilder.newUserTagDefinitionCreationEvent(tagDefinition.getId(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                    try {
                        DefaultTagDefinitionDao.this.bus.postFromTransaction((BusEvent)tagDefinitionEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
                    }
                    catch (PersistentBus.EventBusException e) {
                        log.warn("Failed to post tag definition creation event for tagDefinitionId='{}'", (Object)tagDefinition.getId(), (Object)e);
                    }
                    return tagDefinition;
                }
            });
        }
        catch (TransactionFailedException exception) {
            if (exception.getCause() instanceof TagDefinitionApiException) {
                throw (TagDefinitionApiException)exception.getCause();
            }
            throw exception;
        }
    }

    @Override
    public void deleteById(final UUID definitionId, final InternalCallContext context) throws TagDefinitionApiException {
        try {
            this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<Void>(){

                @Override
                public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                    TagDefinitionSqlDao tagDefinitionSqlDao = entitySqlDaoWrapperFactory.become(TagDefinitionSqlDao.class);
                    TagDefinitionModelDao tagDefinition = (TagDefinitionModelDao)tagDefinitionSqlDao.getById(definitionId.toString(), (InternalTenantContext)context);
                    if (tagDefinition == null) {
                        throw new TagDefinitionApiException(ErrorCode.TAG_DEFINITION_DOES_NOT_EXIST, new Object[]{definitionId});
                    }
                    if (tagDefinitionSqlDao.tagDefinitionUsageCount(definitionId.toString(), (InternalTenantContext)context) > 0) {
                        throw new TagDefinitionApiException(ErrorCode.TAG_DEFINITION_IN_USE, new Object[]{definitionId});
                    }
                    tagDefinitionSqlDao.markTagDefinitionAsDeleted(definitionId.toString(), context);
                    DefaultTagDefinitionDao.this.postBusEventFromTransaction(tagDefinition, tagDefinition, ChangeType.DELETE, entitySqlDaoWrapperFactory, context);
                    return null;
                }
            });
        }
        catch (TransactionFailedException exception) {
            if (exception.getCause() instanceof TagDefinitionApiException) {
                throw (TagDefinitionApiException)exception.getCause();
            }
            throw exception;
        }
    }

    @Override
    protected void postBusEventFromTransaction(TagDefinitionModelDao tagDefinition, TagDefinitionModelDao savedTagDefinition, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
        ControlTagDefinitionCreationInternalEvent tagDefinitionEvent;
        boolean isControlTag = TagModelDaoHelper.isControlTag(tagDefinition.getName());
        switch (changeType) {
            case INSERT: {
                tagDefinitionEvent = isControlTag ? this.tagEventBuilder.newControlTagDefinitionCreationEvent(tagDefinition.getId(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()) : this.tagEventBuilder.newUserTagDefinitionCreationEvent(tagDefinition.getId(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            case DELETE: {
                tagDefinitionEvent = isControlTag ? this.tagEventBuilder.newControlTagDefinitionDeletionEvent(tagDefinition.getId(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()) : this.tagEventBuilder.newUserTagDefinitionDeletionEvent(tagDefinition.getId(), tagDefinition, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.bus.postFromTransaction((BusEvent)tagDefinitionEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post tag definition event for tagDefinitionId='{}'", (Object)tagDefinition.getId().toString(), (Object)e);
        }
    }

    @Override
    protected TagDefinitionApiException generateAlreadyExistsException(TagDefinitionModelDao entity, InternalCallContext context) {
        return new TagDefinitionApiException(ErrorCode.TAG_DEFINITION_ALREADY_EXISTS, new Object[]{entity.getId()});
    }
}

