/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemTags {
    public static final UUID PARK_TAG_DEFINITION_ID = new UUID(1L, 1L);
    public static final String PARK_TAG_DEFINITION_NAME = "__PARK__";
    private static final List<TagDefinitionModelDao> SYSTEM_DEFINED_TAG_DEFINITIONS = ImmutableList.of((Object)new TagDefinitionModelDao(PARK_TAG_DEFINITION_ID, null, null, "__PARK__", "Accounts with invalid invoicing state"));

    public static Collection<TagDefinitionModelDao> get(boolean includeSystemTags) {
        LinkedList<TagDefinitionModelDao> all = includeSystemTags ? new LinkedList<TagDefinitionModelDao>(SYSTEM_DEFINED_TAG_DEFINITIONS) : new LinkedList();
        for (ControlTagType controlTag : ControlTagType.values()) {
            all.add(new TagDefinitionModelDao(controlTag));
        }
        return all;
    }

    public static TagDefinitionModelDao lookup(String tagDefinitionName) {
        for (ControlTagType t : ControlTagType.values()) {
            if (!t.name().equals(tagDefinitionName)) continue;
            return new TagDefinitionModelDao(t);
        }
        for (TagDefinitionModelDao t : SYSTEM_DEFINED_TAG_DEFINITIONS) {
            if (!t.getName().equals(tagDefinitionName)) continue;
            return t;
        }
        return null;
    }

    public static boolean isSystemTag(final UUID tagDefinitionId) {
        return Iterables.any(SYSTEM_DEFINED_TAG_DEFINITIONS, (Predicate)new Predicate<TagDefinitionModelDao>(){

            public boolean apply(TagDefinitionModelDao input) {
                return input.getId().equals(tagDefinitionId);
            }
        });
    }

    public static TagDefinitionModelDao lookup(UUID tagDefinitionId) {
        for (ControlTagType t : ControlTagType.values()) {
            if (!t.getId().equals(tagDefinitionId)) continue;
            return new TagDefinitionModelDao(t);
        }
        for (TagDefinitionModelDao t : SYSTEM_DEFINED_TAG_DEFINITIONS) {
            if (!t.getId().equals(tagDefinitionId)) continue;
            return t;
        }
        return null;
    }
}

