/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.template.translation;

import java.util.ResourceBundle;
import javax.annotation.Nullable;
import org.killbill.billing.util.template.translation.Translator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultTranslatorBase
implements Translator {
    protected final Logger log = LoggerFactory.getLogger(DefaultTranslatorBase.class);
    private final ResourceBundle bundle;
    private final ResourceBundle defaultBundle;

    public DefaultTranslatorBase(@Nullable ResourceBundle bundle, @Nullable ResourceBundle defaultBundle) {
        this.bundle = bundle;
        this.defaultBundle = defaultBundle;
    }

    public String getTranslation(String originalText) {
        if (originalText == null) {
            return null;
        }
        if (this.bundle != null && this.bundle.containsKey(originalText)) {
            return this.bundle.getString(originalText);
        }
        if (this.defaultBundle != null && this.defaultBundle.containsKey(originalText)) {
            return this.defaultBundle.getString(originalText);
        }
        return originalText;
    }
}

