/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.account;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;

public abstract class AccountDateTimeUtils {
    public static DateTimeZone getFixedOffsetTimeZone(TimeZoneAwareEntity account) {
        return AccountDateTimeUtils.getFixedOffsetTimeZone(account.getTimeZone(), account.getReferenceTime());
    }

    public static DateTimeZone getFixedOffsetTimeZone(Account account) {
        return AccountDateTimeUtils.getFixedOffsetTimeZone(account.getTimeZone(), account.getReferenceTime());
    }

    private static DateTimeZone getFixedOffsetTimeZone(DateTimeZone referenceDateTimeZone, DateTime referenceDateTime) {
        boolean shouldUseDST;
        boolean bl = shouldUseDST = !referenceDateTimeZone.isStandardOffset(referenceDateTime.getMillis());
        if (shouldUseDST) {
            return DateTimeZone.forOffsetMillis((int)referenceDateTimeZone.getOffset(referenceDateTime.getMillis()));
        }
        return DateTimeZone.forOffsetMillis((int)referenceDateTimeZone.getStandardOffset(referenceDateTime.getMillis()));
    }
}

