/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.dao.AuditLogModelDao;
import org.killbill.billing.util.entity.Entity;

public class DefaultAuditLog
extends EntityBase
implements AuditLog {
    private final AuditLogModelDao auditLogModelDao;
    private final ObjectType objectType;
    private final UUID auditedEntityId;

    public DefaultAuditLog(AuditLogModelDao auditLogModelDao, ObjectType objectType, UUID auditedEntityId) {
        super((Entity)auditLogModelDao);
        this.auditLogModelDao = auditLogModelDao;
        this.objectType = objectType;
        this.auditedEntityId = auditedEntityId;
    }

    public UUID getAuditedEntityId() {
        return this.auditedEntityId;
    }

    public ObjectType getAuditedObjectType() {
        return this.objectType;
    }

    public ChangeType getChangeType() {
        return this.auditLogModelDao.getChangeType();
    }

    public String getUserName() {
        return this.auditLogModelDao.getCallContext().getUserName();
    }

    public DateTime getCreatedDate() {
        return this.auditLogModelDao.getCallContext().getCreatedDate();
    }

    public String getReasonCode() {
        return this.auditLogModelDao.getCallContext().getReasonCode();
    }

    public String getUserToken() {
        if (this.auditLogModelDao.getCallContext().getUserToken() == null) {
            return null;
        }
        return this.auditLogModelDao.getCallContext().getUserToken().toString();
    }

    public String getComment() {
        return this.auditLogModelDao.getCallContext().getComments();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultAuditLog{");
        sb.append("auditLogModelDao=").append(this.auditLogModelDao);
        sb.append(", auditedEntityId=").append(this.auditedEntityId);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultAuditLog that = (DefaultAuditLog)((Object)o);
        if (this.auditLogModelDao != null ? !this.auditLogModelDao.equals(that.auditLogModelDao) : that.auditLogModelDao != null) {
            return false;
        }
        return !(this.auditedEntityId != null ? !this.auditedEntityId.equals(that.auditedEntityId) : that.auditedEntityId != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.auditLogModelDao != null ? this.auditLogModelDao.hashCode() : 0);
        result = 31 * result + (this.auditedEntityId != null ? this.auditedEntityId.hashCode() : 0);
        return result;
    }
}

