/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.api;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.DefaultAccountAuditLogs;
import org.killbill.billing.util.audit.DefaultAccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.dao.TableName;

public class DefaultAuditUserApi
implements AuditUserApi {
    private final AuditDao auditDao;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public DefaultAuditUserApi(AuditDao auditDao, InternalCallContextFactory internalCallContextFactory) {
        this.auditDao = auditDao;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public AccountAuditLogs getAccountAuditLogs(UUID accountId, AuditLevel auditLevel, TenantContext tenantContext) {
        if (AuditLevel.NONE.equals((Object)auditLevel)) {
            return new DefaultAccountAuditLogs(accountId);
        }
        return this.auditDao.getAuditLogsForAccountRecordId(auditLevel, this.internalCallContextFactory.createInternalTenantContext(accountId, tenantContext));
    }

    public AccountAuditLogsForObjectType getAccountAuditLogs(UUID accountId, ObjectType objectType, AuditLevel auditLevel, TenantContext tenantContext) {
        if (AuditLevel.NONE.equals((Object)auditLevel)) {
            return new DefaultAccountAuditLogsForObjectType(auditLevel);
        }
        TableName tableName = this.getTableNameFromObjectType(objectType);
        if (tableName == null) {
            return new DefaultAccountAuditLogsForObjectType(auditLevel);
        }
        return this.auditDao.getAuditLogsForAccountRecordId(tableName, auditLevel, this.internalCallContextFactory.createInternalTenantContext(accountId, tenantContext));
    }

    public List<AuditLog> getAuditLogs(UUID objectId, ObjectType objectType, AuditLevel auditLevel, TenantContext context) {
        if (AuditLevel.NONE.equals((Object)auditLevel)) {
            return ImmutableList.of();
        }
        TableName tableName = this.getTableNameFromObjectType(objectType);
        if (tableName == null) {
            return ImmutableList.of();
        }
        return this.auditDao.getAuditLogsForId(tableName, objectId, auditLevel, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
    }

    private TableName getTableNameFromObjectType(ObjectType objectType) {
        for (TableName tableName : TableName.values()) {
            if (!objectType.equals((Object)tableName.getObjectType())) continue;
            return tableName;
        }
        return null;
    }
}

