/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.dao;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.dao.EntityAudit;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDao;

public class AuditLogModelDao
implements EntityModelDao<AuditLog>,
Externalizable {
    private UUID id;
    private DateTime createdDate;
    private DateTime updatedDate;
    private TableName tableName;
    private Long targetRecordId;
    private ChangeType changeType;
    private DefaultCallContext callContext;
    private Long recordId;
    private Long accountRecordId;
    private Long tenantRecordId;

    public AuditLogModelDao() {
    }

    public AuditLogModelDao(EntityAudit entityAudit, DefaultCallContext callContext) {
        this.id = entityAudit.getId();
        this.tableName = entityAudit.getTableName();
        this.targetRecordId = entityAudit.getTargetRecordId();
        this.changeType = entityAudit.getChangeType();
        this.createdDate = entityAudit.getCreatedDate();
        this.updatedDate = null;
        this.callContext = callContext;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    public Long getTargetRecordId() {
        return this.targetRecordId;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    @Override
    public Long getRecordId() {
        return this.recordId;
    }

    @Override
    public Long getAccountRecordId() {
        return this.accountRecordId;
    }

    @Override
    public Long getTenantRecordId() {
        return this.tenantRecordId;
    }

    @Override
    public TableName getHistoryTableName() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AuditLogModelDao{");
        sb.append("id=").append(this.id);
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", updatedDate=").append(this.updatedDate);
        sb.append(", tableName=").append((Object)this.tableName);
        sb.append(", targetRecordId=").append(this.targetRecordId);
        sb.append(", changeType=").append(this.changeType);
        sb.append(", callContext=").append(this.callContext);
        sb.append(", recordId=").append(this.recordId);
        sb.append(", accountRecordId=").append(this.accountRecordId);
        sb.append(", tenantRecordId=").append(this.tenantRecordId);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogModelDao that = (AuditLogModelDao)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.createdDate != null ? this.createdDate.compareTo((ReadableInstant)that.createdDate) != 0 : that.createdDate != null) {
            return false;
        }
        if (this.updatedDate != null ? this.updatedDate.compareTo((ReadableInstant)that.updatedDate) != 0 : that.updatedDate != null) {
            return false;
        }
        if (this.tableName != that.tableName) {
            return false;
        }
        if (this.targetRecordId != null ? !this.targetRecordId.equals(that.targetRecordId) : that.targetRecordId != null) {
            return false;
        }
        if (this.changeType != that.changeType) {
            return false;
        }
        if (this.callContext != null ? !this.callContext.equals((Object)that.callContext) : that.callContext != null) {
            return false;
        }
        if (this.recordId != null ? !this.recordId.equals(that.recordId) : that.recordId != null) {
            return false;
        }
        if (this.accountRecordId != null ? !this.accountRecordId.equals(that.accountRecordId) : that.accountRecordId != null) {
            return false;
        }
        return this.tenantRecordId != null ? this.tenantRecordId.equals(that.tenantRecordId) : that.tenantRecordId == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.targetRecordId != null ? this.targetRecordId.hashCode() : 0);
        result = 31 * result + (this.changeType != null ? this.changeType.hashCode() : 0);
        result = 31 * result + (this.callContext != null ? this.callContext.hashCode() : 0);
        result = 31 * result + (this.recordId != null ? this.recordId.hashCode() : 0);
        result = 31 * result + (this.accountRecordId != null ? this.accountRecordId.hashCode() : 0);
        result = 31 * result + (this.tenantRecordId != null ? this.tenantRecordId.hashCode() : 0);
        return result;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = new UUID(in.readLong(), in.read());
        this.createdDate = new DateTime((Object)in.readUTF());
        this.updatedDate = new DateTime((Object)in.readUTF());
        this.tableName = TableName.valueOf(in.readUTF());
        this.targetRecordId = in.readLong();
        this.changeType = ChangeType.valueOf((String)in.readUTF());
        this.callContext = (DefaultCallContext)in.readObject();
        this.recordId = in.readLong();
        this.accountRecordId = in.readLong();
        this.tenantRecordId = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeLong(this.id.getMostSignificantBits());
        oo.writeLong(this.id.getLeastSignificantBits());
        oo.writeUTF(this.createdDate.toString());
        oo.writeUTF(this.updatedDate.toString());
        oo.writeUTF(this.tableName.name());
        oo.writeLong(this.targetRecordId);
        oo.writeUTF(this.changeType.name());
        oo.writeObject(this.callContext);
        oo.writeLong(this.recordId);
        oo.writeLong(this.accountRecordId);
        oo.writeLong(this.tenantRecordId);
    }
}

