/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.bcd;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BillCycleDayCalculator {
    private static final Logger log = LoggerFactory.getLogger(BillCycleDayCalculator.class);

    public static int calculateBcdForAlignment(@Nullable Map<UUID, Integer> bcdCache, SubscriptionBase subscription, SubscriptionBase baseSubscription, BillingAlignment alignment, InternalTenantContext internalTenantContext, int accountBillCycleDayLocal) {
        int result = 0;
        switch (alignment) {
            case ACCOUNT: {
                Preconditions.checkState((accountBillCycleDayLocal != 0 ? 1 : 0) != 0, (Object)"Account BCD should be set at this point");
                result = accountBillCycleDayLocal;
                break;
            }
            case BUNDLE: {
                result = BillCycleDayCalculator.calculateOrRetrieveBcdFromSubscription(bcdCache, baseSubscription, internalTenantContext);
                break;
            }
            case SUBSCRIPTION: {
                result = BillCycleDayCalculator.calculateOrRetrieveBcdFromSubscription(bcdCache, subscription, internalTenantContext);
            }
        }
        return result;
    }

    public static LocalDate alignProposedBillCycleDate(LocalDate proposedDate, int billingCycleDay, BillingPeriod billingPeriod) {
        boolean isMonthBased;
        boolean bl = isMonthBased = (billingPeriod.getPeriod().getMonths() | billingPeriod.getPeriod().getYears()) > 0;
        if (!isMonthBased) {
            return proposedDate;
        }
        int lastDayOfMonth = proposedDate.dayOfMonth().getMaximumValue();
        int proposedBillCycleDate = proposedDate.getDayOfMonth();
        if (proposedBillCycleDate < billingCycleDay) {
            proposedBillCycleDate = billingCycleDay <= lastDayOfMonth ? billingCycleDay : lastDayOfMonth;
        }
        return new LocalDate(proposedDate.getYear(), proposedDate.getMonthOfYear(), proposedBillCycleDate, proposedDate.getChronology());
    }

    public static LocalDate alignProposedBillCycleDate(DateTime proposedDate, int billingCycleDay, BillingPeriod billingPeriod, InternalTenantContext internalTenantContext) {
        LocalDate proposedLocalDate = internalTenantContext.toLocalDate(proposedDate);
        LocalDate resultingLocalDate = BillCycleDayCalculator.alignProposedBillCycleDate(proposedLocalDate, billingCycleDay, billingPeriod);
        return resultingLocalDate;
    }

    private static int calculateOrRetrieveBcdFromSubscription(@Nullable Map<UUID, Integer> bcdCache, SubscriptionBase subscription, InternalTenantContext internalTenantContext) {
        Integer result;
        Integer n = result = bcdCache != null ? bcdCache.get(subscription.getId()) : null;
        if (result == null) {
            result = BillCycleDayCalculator.calculateBcdFromSubscription(subscription, internalTenantContext);
            if (bcdCache != null) {
                bcdCache.put(subscription.getId(), result);
            }
        }
        return result;
    }

    private static int calculateBcdFromSubscription(SubscriptionBase subscription, InternalTenantContext internalTenantContext) {
        DateTime date = subscription.getDateOfFirstRecurringNonZeroCharge();
        int bcdLocal = internalTenantContext.toLocalDate(date).getDayOfMonth();
        log.debug("Calculated BCD: subscriptionId='{}', subscriptionStartDate='{}', bcd='{}'", new Object[]{subscription.getId(), date.toDateTimeISO(), bcdLocal});
        return bcdLocal;
    }
}

