/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.broadcast;

import javax.inject.Inject;
import org.joda.time.DateTime;
import org.killbill.billing.broadcast.BroadcastApi;
import org.killbill.billing.util.broadcast.DefaultBroadcastInternalEvent;
import org.killbill.billing.util.broadcast.dao.BroadcastDao;
import org.killbill.billing.util.broadcast.dao.BroadcastModelDao;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcastApi
implements BroadcastApi {
    private final Logger logger = LoggerFactory.getLogger(DefaultBroadcastApi.class);
    private final BroadcastDao dao;
    private final PersistentBus eventBus;

    @Inject
    public DefaultBroadcastApi(BroadcastDao dao, PersistentBus eventBus) {
        this.dao = dao;
        this.eventBus = eventBus;
    }

    public void broadcast(String serviceName, String type, String event, DateTime createdDate, String createdBy, boolean localNodeOnly) {
        if (localNodeOnly) {
            DefaultBroadcastInternalEvent busEvent = new DefaultBroadcastInternalEvent(serviceName, type, event);
            try {
                this.eventBus.post((BusEvent)busEvent);
            }
            catch (PersistentBus.EventBusException e) {
                this.logger.warn("Failed to post event {}", (Object)event, (Object)e);
            }
        } else {
            BroadcastModelDao modelDao = new BroadcastModelDao(serviceName, type, event, createdDate, createdBy);
            this.dao.create(modelDao);
        }
    }
}

