/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.broadcast.dao;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.killbill.billing.util.broadcast.dao.BroadcastDao;
import org.killbill.billing.util.broadcast.dao.BroadcastModelDao;
import org.killbill.billing.util.broadcast.dao.BroadcastSqlDao;
import org.killbill.billing.util.entity.dao.DBRouter;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

public class DefaultBroadcastDao
implements BroadcastDao {
    private final DBRouter<BroadcastSqlDao> dbRouter;

    @Inject
    public DefaultBroadcastDao(IDBI dbi, @Named(value="main-ro") IDBI roDbi) {
        this.dbRouter = new DBRouter<BroadcastSqlDao>(dbi, roDbi, BroadcastSqlDao.class);
    }

    @Override
    public void create(final BroadcastModelDao broadcastModelDao) {
        this.dbRouter.inTransaction(false, new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                BroadcastSqlDao sqlDao = (BroadcastSqlDao)handle.attach(BroadcastSqlDao.class);
                sqlDao.create(broadcastModelDao);
                return null;
            }
        });
    }

    @Override
    public List<BroadcastModelDao> getLatestEntriesFrom(final Long recordId) {
        return this.dbRouter.inTransaction(true, new TransactionCallback<List<BroadcastModelDao>>(){

            public List<BroadcastModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                BroadcastSqlDao sqlDao = (BroadcastSqlDao)handle.attach(BroadcastSqlDao.class);
                return sqlDao.getLatestEntries(recordId);
            }
        });
    }

    @Override
    public BroadcastModelDao getLatestEntry() {
        return this.dbRouter.inTransaction(true, new TransactionCallback<BroadcastModelDao>(){

            public BroadcastModelDao inTransaction(Handle handle, TransactionStatus status) throws Exception {
                BroadcastSqlDao sqlDao = (BroadcastSqlDao)handle.attach(BroadcastSqlDao.class);
                return sqlDao.getLatestEntry();
            }
        });
    }
}

