/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.UUID;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;

@Singleton
public class BundleIdFromSubscriptionIdCacheLoader
extends BaseCacheLoader<UUID, UUID> {
    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.BUNDLE_ID_FROM_SUBSCRIPTION_ID;
    }

    @Override
    public UUID compute(UUID key, CacheLoaderArgument cacheLoaderArgument) {
        if (cacheLoaderArgument.getArgs() == null || !(cacheLoaderArgument.getArgs()[0] instanceof LoaderCallback)) {
            throw new IllegalArgumentException("Missing LoaderCallback from the arguments ");
        }
        LoaderCallback callback = (LoaderCallback)cacheLoaderArgument.getArgs()[0];
        return callback.loadBundleId(key, cacheLoaderArgument.getInternalTenantContext());
    }

    public static interface LoaderCallback {
        public UUID loadBundleId(UUID var1, InternalTenantContext var2);
    }
}

