/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.UUID;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.util.config.tenant.PerTenantConfig;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface Cachable {
    public static final String RECORD_ID_CACHE_NAME = "record-id";
    public static final String ACCOUNT_RECORD_ID_CACHE_NAME = "account-record-id";
    public static final String TENANT_RECORD_ID_CACHE_NAME = "tenant-record-id";
    public static final String OBJECT_ID_CACHE_NAME = "object-id";
    public static final String TENANT_CATALOG_CACHE_NAME = "tenant-catalog";
    public static final String TENANT_PAYMENT_STATE_MACHINE_CONFIG_CACHE_NAME = "tenant-payment-state-machine-config";
    public static final String TENANT_OVERDUE_CONFIG_CACHE_NAME = "tenant-overdue-config";
    public static final String TENANT_CONFIG_CACHE_NAME = "tenant-config";
    public static final String TENANT_KV_CACHE_NAME = "tenant-kv";
    public static final String TENANT_CACHE_NAME = "tenant";
    public static final String OVERRIDDEN_PLAN_CACHE_NAME = "overridden-plan";
    public static final String ACCOUNT_IMMUTABLE_CACHE_NAME = "account-immutable";
    public static final String ACCOUNT_BCD_CACHE_NAME = "account-bcd";
    public static final String ACCOUNT_ID_FROM_BUNDLE_ID_CACHE_NAME = "account-id-from-bundle-id";
    public static final String BUNDLE_ID_FROM_SUBSCRIPTION_ID_CACHE_NAME = "bundle-id-from-subscription-id";

    public CacheType value();

    public static enum CacheType {
        RECORD_ID("record-id", String.class, Long.class, false),
        ACCOUNT_RECORD_ID("account-record-id", String.class, Long.class, false),
        TENANT_RECORD_ID("tenant-record-id", String.class, Long.class, false),
        OBJECT_ID("object-id", String.class, UUID.class, true),
        TENANT_CATALOG("tenant-catalog", Long.class, VersionedCatalog.class, false),
        TENANT_PAYMENT_STATE_MACHINE_CONFIG("tenant-payment-state-machine-config", String.class, Object.class, false),
        TENANT_OVERDUE_CONFIG("tenant-overdue-config", Long.class, Object.class, false),
        TENANT_CONFIG("tenant-config", Long.class, PerTenantConfig.class, false),
        TENANT_KV("tenant-kv", String.class, String.class, false),
        TENANT("tenant", String.class, Tenant.class, false),
        OVERRIDDEN_PLAN("overridden-plan", String.class, Plan.class, false),
        ACCOUNT_IMMUTABLE("account-immutable", Long.class, ImmutableAccountData.class, false),
        ACCOUNT_BCD("account-bcd", UUID.class, Integer.class, false),
        ACCOUNT_ID_FROM_BUNDLE_ID("account-id-from-bundle-id", UUID.class, UUID.class, false),
        BUNDLE_ID_FROM_SUBSCRIPTION_ID("bundle-id-from-subscription-id", UUID.class, UUID.class, false);

        private final String cacheName;
        private final Class keyType;
        private final Class valueType;
        private final boolean isKeyPrefixedWithTableName;

        private CacheType(String cacheName, Class keyType, Class valueType, boolean isKeyPrefixedWithTableName) {
            this.cacheName = cacheName;
            this.keyType = keyType;
            this.valueType = valueType;
            this.isKeyPrefixedWithTableName = isKeyPrefixedWithTableName;
        }

        public static CacheType findByName(String input) {
            for (CacheType cacheType : CacheType.values()) {
                if (!cacheType.cacheName.equals(input)) continue;
                return cacheType;
            }
            return null;
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public Class<?> getKeyType() {
            return this.keyType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public boolean isKeyPrefixedWithTableName() {
            return this.isKeyPrefixedWithTableName;
        }
    }
}

