/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.inject.Inject;
import javax.inject.Provider;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.KillBillCacheController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheControllerDispatcherProvider
implements Provider<CacheControllerDispatcher> {
    private static final Logger logger = LoggerFactory.getLogger(CacheControllerDispatcherProvider.class);
    private final CacheManager cacheManager;
    private final Set<BaseCacheLoader> cacheLoaders;

    @Inject
    public CacheControllerDispatcherProvider(CacheManager cacheManager, Set<BaseCacheLoader> cacheLoaders) {
        this.cacheManager = cacheManager;
        this.cacheLoaders = cacheLoaders;
    }

    public CacheControllerDispatcher get() {
        LinkedHashMap<Cachable.CacheType, CacheController<Object, Object>> cacheControllers = new LinkedHashMap<Cachable.CacheType, CacheController<Object, Object>>();
        for (BaseCacheLoader cacheLoader : this.cacheLoaders) {
            Cachable.CacheType cacheType = cacheLoader.getCacheType();
            Cache cache = this.cacheManager.getCache(cacheType.getCacheName(), cacheType.getKeyType(), cacheType.getValueType());
            if (cache == null) {
                logger.warn("Cache for cacheName='{}' not configured", (Object)cacheLoader.getCacheType().getCacheName());
                continue;
            }
            Preconditions.checkState((!cache.isClosed() ? 1 : 0) != 0, (String)"Cache '%s' should not be closed", (Object)cacheType.getCacheName());
            KillBillCacheController killBillCacheController = new KillBillCacheController(cache, cacheLoader);
            cacheControllers.put(cacheType, killBillCacheController);
        }
        return new CacheControllerDispatcher(cacheControllers);
    }
}

