/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillBillCacheController<K, V>
implements CacheController<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(KillBillCacheController.class);
    private final Cache<K, V> cache;
    private final BaseCacheLoader<K, V> baseCacheLoader;

    public KillBillCacheController(Cache<K, V> cache, BaseCacheLoader<K, V> baseCacheLoader) {
        this.cache = cache;
        this.baseCacheLoader = baseCacheLoader;
    }

    @Override
    public List<K> getKeys() {
        Iterable kIterable = Iterables.transform(this.cache, (Function)new Function<Cache.Entry<K, V>, K>(){

            public K apply(Cache.Entry<K, V> input) {
                return input.getKey();
            }
        });
        return ImmutableList.copyOf((Iterable)kIterable);
    }

    @Override
    public boolean isKeyInCache(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public V get(K key, CacheLoaderArgument cacheLoaderArgument) {
        Object value;
        if (key == null) {
            return null;
        }
        try {
            value = !this.isKeyInCache(key) ? this.computeAndCacheValue(key, cacheLoaderArgument) : this.cache.get(key);
        }
        catch (CacheException e) {
            logger.warn("Unable to retrieve cached value for key='{}' and cacheLoaderArgument='{}'", new Object[]{key, cacheLoaderArgument, e});
            value = this.computeValue(key, cacheLoaderArgument);
        }
        if (value == null || value.equals("__#VALEUR!__")) {
            return null;
        }
        return value;
    }

    @Override
    public void putIfAbsent(K key, V value) {
        this.cache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(K key) {
        if (this.isKeyInCache(key)) {
            this.cache.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public void remove(Function<K, Boolean> keyMatcher) {
        HashSet<K> toRemove = new HashSet<K>();
        for (K key : this.getKeys()) {
            if (keyMatcher.apply(key) != Boolean.TRUE) continue;
            toRemove.add(key);
        }
        this.cache.removeAll(toRemove);
    }

    @Override
    public void removeAll() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return Iterables.size(this.cache);
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return this.baseCacheLoader.getCacheType();
    }

    private V computeAndCacheValue(K key, CacheLoaderArgument cacheLoaderArgument) {
        V value = this.computeValue(key, cacheLoaderArgument);
        if (value == null) {
            return null;
        }
        this.putIfAbsent(key, value);
        return value;
    }

    private V computeValue(K key, CacheLoaderArgument cacheLoaderArgument) {
        V value;
        try {
            value = this.baseCacheLoader.compute(key, cacheLoaderArgument);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }
}

