/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.cache.BaseIdCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.dao.NonEntityDao;
import org.skife.jdbi.v2.Handle;

@Singleton
public class ObjectIdCacheLoader
extends BaseIdCacheLoader<UUID> {
    private final NonEntityDao nonEntityDao;

    @Inject
    public ObjectIdCacheLoader(NonEntityDao nonEntityDao) {
        this.nonEntityDao = nonEntityDao;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.OBJECT_ID;
    }

    @Override
    protected UUID doRetrieveOperation(String rawKey, ObjectType objectType, Handle handle) {
        Long recordId = Long.valueOf(rawKey);
        return this.nonEntityDao.retrieveIdFromObjectInTransaction(recordId, objectType, null, handle);
    }
}

