/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TenantCatalogCacheLoader
extends BaseCacheLoader<Long, VersionedCatalog> {
    private final Logger log = LoggerFactory.getLogger(TenantCatalogCacheLoader.class);
    private final TenantInternalApi tenantApi;

    @Inject
    public TenantCatalogCacheLoader(TenantInternalApi tenantApi) {
        this.tenantApi = tenantApi;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.TENANT_CATALOG;
    }

    @Override
    public VersionedCatalog compute(Long key, CacheLoaderArgument cacheLoaderArgument) {
        Long tenantRecordId = key;
        InternalTenantContext internalTenantContext = new InternalTenantContext(tenantRecordId);
        if (cacheLoaderArgument.getArgs() == null || !(cacheLoaderArgument.getArgs()[0] instanceof LoaderCallback)) {
            throw new IllegalArgumentException("Missing LoaderCallback from the arguments ");
        }
        LoaderCallback callback = (LoaderCallback)cacheLoaderArgument.getArgs()[0];
        List catalogXMLs = this.tenantApi.getTenantCatalogs(internalTenantContext);
        if (catalogXMLs.isEmpty()) {
            return null;
        }
        try {
            this.log.info("Loading catalog cache for tenantRecordId='{}'", (Object)internalTenantContext.getTenantRecordId());
            return callback.loadCatalog(catalogXMLs, tenantRecordId);
        }
        catch (CatalogApiException e) {
            throw new IllegalStateException(String.format("Failed to de-serialize catalog for tenantRecordId='%s'", internalTenantContext.getTenantRecordId()), e);
        }
    }

    public static interface LoaderCallback {
        public VersionedCatalog loadCatalog(List<String> var1, Long var2) throws CatalogApiException;
    }
}

