/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;

@Singleton
public class TenantKVCacheLoader
extends BaseCacheLoader<String, String> {
    private final TenantInternalApi tenantApi;

    @Inject
    public TenantKVCacheLoader(TenantInternalApi tenantApi) {
        this.tenantApi = tenantApi;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.TENANT_KV;
    }

    @Override
    public String compute(String key, CacheLoaderArgument cacheLoaderArgument) {
        String tenantRecordId;
        InternalTenantContext internalTenantContext;
        String[] parts = key.split("::");
        String rawKey = parts[0];
        List valuesForKey = this.tenantApi.getTenantValuesForKey(rawKey, internalTenantContext = new InternalTenantContext(Long.valueOf(tenantRecordId = parts[1])));
        if (valuesForKey == null || valuesForKey.isEmpty()) {
            return "__#VALEUR!__";
        }
        if (valuesForKey.size() > 1) {
            throw new IllegalStateException("TenantKVCacheLoader expecting no more than one value for key " + key);
        }
        return (String)valuesForKey.get(0);
    }
}

