/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TenantStateMachineConfigCacheLoader
extends BaseCacheLoader<String, Object> {
    private static final Pattern PATTERN = Pattern.compile(TenantKV.TenantKey.PLUGIN_PAYMENT_STATE_MACHINE_.toString() + "(.*)");
    private static final Logger log = LoggerFactory.getLogger(TenantStateMachineConfigCacheLoader.class);
    private final TenantInternalApi tenantApi;

    @Inject
    public TenantStateMachineConfigCacheLoader(TenantInternalApi tenantApi) {
        this.tenantApi = tenantApi;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.TENANT_PAYMENT_STATE_MACHINE_CONFIG;
    }

    @Override
    public Object compute(String key, CacheLoaderArgument cacheLoaderArgument) {
        String[] parts = key.split("::");
        String rawKey = parts[0];
        Matcher matcher = PATTERN.matcher(rawKey);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected key " + rawKey);
        }
        String pluginName = matcher.group(1);
        String tenantRecordId = parts[1];
        LoaderCallback callback = (LoaderCallback)cacheLoaderArgument.getArgs()[0];
        InternalTenantContext internalTenantContext = new InternalTenantContext(Long.valueOf(tenantRecordId));
        String stateMachineConfigXML = this.tenantApi.getPluginPaymentStateMachineConfig(pluginName, internalTenantContext);
        if (stateMachineConfigXML == null) {
            return null;
        }
        try {
            log.info("Loading config state machine cache for pluginName='{}', tenantRecordId='{}'", (Object)pluginName, (Object)internalTenantContext.getTenantRecordId());
            return callback.loadStateMachineConfig(stateMachineConfigXML);
        }
        catch (PaymentApiException e) {
            throw new IllegalStateException(String.format("Failed to de-serialize state machine config for tenantRecordId='%s'", internalTenantContext.getTenantRecordId()), e);
        }
    }

    public static interface LoaderCallback {
        public Object loadStateMachineConfig(String var1) throws PaymentApiException;
    }
}

