/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.account.AccountDateTimeUtils;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;
import org.killbill.clock.Clock;
import org.slf4j.MDC;

public class InternalCallContextFactory {
    public static final Long INTERNAL_TENANT_RECORD_ID = 0L;
    public static final String MDC_KB_ACCOUNT_RECORD_ID = "kb.accountRecordId";
    public static final String MDC_KB_TENANT_RECORD_ID = "kb.tenantRecordId";
    public static final String MDC_KB_USER_TOKEN = "kb.userToken";
    private final ImmutableAccountInternalApi accountInternalApi;
    private final Clock clock;
    private final NonEntityDao nonEntityDao;
    private final CacheController<String, UUID> objectIdCacheController;
    private final CacheController<String, Long> recordIdCacheController;
    private final CacheController<String, Long> accountRecordIdCacheController;
    private final CacheController<String, Long> tenantRecordIdCacheController;

    @Inject
    public InternalCallContextFactory(@Nullable ImmutableAccountInternalApi accountInternalApi, Clock clock, NonEntityDao nonEntityDao, @Nullable CacheControllerDispatcher cacheControllerDispatcher) {
        this.accountInternalApi = accountInternalApi;
        this.clock = clock;
        this.nonEntityDao = nonEntityDao;
        if (cacheControllerDispatcher == null) {
            this.objectIdCacheController = null;
            this.recordIdCacheController = null;
            this.accountRecordIdCacheController = null;
            this.tenantRecordIdCacheController = null;
        } else {
            this.objectIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.OBJECT_ID);
            this.recordIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
            this.accountRecordIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_RECORD_ID);
            this.tenantRecordIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_RECORD_ID);
        }
    }

    public TenantContext createTenantContext(InternalTenantContext context) {
        UUID accountId = this.getAccountIdSafe(context);
        UUID tenantId = this.getTenantIdSafe(context);
        return context.toTenantContext(accountId, tenantId);
    }

    public CallContext createCallContext(InternalCallContext context) {
        UUID accountId = this.getAccountIdSafe((InternalTenantContext)context);
        UUID tenantId = this.getTenantIdSafe((InternalTenantContext)context);
        return context.toCallContext(accountId, tenantId);
    }

    public InternalTenantContext createInternalTenantContextWithoutAccountRecordId(TenantContext context) {
        Long tenantRecordId = this.getTenantRecordIdSafe(context);
        return this.createInternalTenantContext(tenantRecordId, null);
    }

    public InternalTenantContext createInternalTenantContext(UUID accountId, TenantContext context) {
        return this.createInternalTenantContext(accountId, ObjectType.ACCOUNT, context);
    }

    public InternalTenantContext createInternalTenantContext(UUID accountId, InternalTenantContext context) {
        Long tenantRecordId = context.getTenantRecordId();
        Long accountRecordId = this.getAccountRecordIdSafe(accountId, ObjectType.ACCOUNT, context.getTenantRecordId());
        return this.createInternalTenantContext(tenantRecordId, accountRecordId);
    }

    public InternalTenantContext createInternalTenantContext(UUID objectId, ObjectType objectType, TenantContext context) {
        Long tenantRecordId = this.getTenantRecordIdSafe(context);
        Long accountRecordId = this.getAccountRecordIdSafe(objectId, objectType, context);
        return this.createInternalTenantContext(tenantRecordId, accountRecordId);
    }

    public InternalTenantContext createInternalTenantContext(Long tenantRecordId, @Nullable Long accountRecordId) {
        this.populateMDCContext(null, accountRecordId, tenantRecordId);
        if (accountRecordId == null) {
            return new InternalTenantContext(tenantRecordId);
        }
        ImmutableAccountData immutableAccountData = this.getImmutableAccountData(accountRecordId, tenantRecordId);
        DateTimeZone fixedOffsetTimeZone = immutableAccountData.getFixedOffsetTimeZone();
        DateTime referenceTime = immutableAccountData.getReferenceTime();
        return new InternalTenantContext(tenantRecordId, accountRecordId, fixedOffsetTimeZone, referenceTime);
    }

    public InternalCallContext createInternalCallContext(UUID accountId, CallContext context) {
        return this.createInternalCallContext(accountId, ObjectType.ACCOUNT, context);
    }

    public InternalCallContext createInternalCallContext(UUID objectId, ObjectType objectType, CallContext context) {
        Long tenantRecordId = this.getTenantRecordIdSafe((TenantContext)context);
        Long accountRecordId = this.getAccountRecordIdSafe(objectId, objectType, (TenantContext)context);
        return this.createInternalCallContext(tenantRecordId, accountRecordId, context.getUserName(), context.getCallOrigin(), context.getUserType(), context.getUserToken(), context.getReasonCode(), context.getComments(), context.getCreatedDate(), context.getUpdatedDate());
    }

    public InternalCallContext createInternalCallContext(UUID objectId, ObjectType objectType, String userName, CallOrigin callOrigin, UserType userType, @Nullable UUID userToken, Long tenantRecordId) {
        Long accountRecordId = this.getAccountRecordIdSafe(objectId, objectType, tenantRecordId);
        return this.createInternalCallContext(tenantRecordId, accountRecordId, userName, callOrigin, userType, userToken, null, null, null, null);
    }

    public InternalCallContext createInternalCallContext(@Nullable Long tenantRecordId, @Nullable Long accountRecordId, String userName, CallOrigin callOrigin, UserType userType, @Nullable UUID userToken) {
        return this.createInternalCallContext(tenantRecordId, accountRecordId, userName, callOrigin, userType, userToken, null, null, null, null);
    }

    public InternalCallContext createInternalCallContextWithoutAccountRecordId(CallContext context) {
        Long tenantRecordId = this.getTenantRecordIdSafe((TenantContext)context);
        this.populateMDCContext(context.getUserToken(), null, tenantRecordId);
        return new InternalCallContext(tenantRecordId, context, context.getCreatedDate());
    }

    public InternalCallContext createInternalCallContext(Long accountRecordId, InternalCallContext context) {
        ImmutableAccountData immutableAccountData = this.getImmutableAccountData(accountRecordId, context.getTenantRecordId());
        DateTimeZone fixedOffsetTimeZone = immutableAccountData.getFixedOffsetTimeZone();
        DateTime referenceTime = immutableAccountData.getReferenceTime();
        this.populateMDCContext(context.getUserToken(), accountRecordId, context.getTenantRecordId());
        return new InternalCallContext(context, accountRecordId, fixedOffsetTimeZone, referenceTime, context.getCreatedDate());
    }

    public InternalCallContext createInternalCallContext(TimeZoneAwareEntity accountModelDao, Long accountRecordId, InternalCallContext context) {
        DateTimeZone fixedOffsetTimeZone = AccountDateTimeUtils.getFixedOffsetTimeZone(accountModelDao);
        DateTime referenceTime = accountModelDao.getReferenceTime();
        this.populateMDCContext(context.getUserToken(), accountRecordId, context.getTenantRecordId());
        return new InternalCallContext(context, accountRecordId, fixedOffsetTimeZone, referenceTime, context.getCreatedDate());
    }

    public InternalCallContext createInternalCallContext(DateTimeZone fixedOffsetTimeZone, DateTime referenceTime, Long accountRecordId, InternalCallContext context) {
        this.populateMDCContext(context.getUserToken(), accountRecordId, context.getTenantRecordId());
        return new InternalCallContext(context, accountRecordId, fixedOffsetTimeZone, referenceTime, context.getCreatedDate());
    }

    private InternalCallContext createInternalCallContext(@Nullable Long tenantRecordId, @Nullable Long accountRecordId, String userName, CallOrigin callOrigin, UserType userType, @Nullable UUID userToken, @Nullable String reasonCode, @Nullable String comment, @Nullable DateTime createdDate, @Nullable DateTime updatedDate) {
        DateTime referenceTime;
        DateTimeZone fixedOffsetTimeZone;
        Long nonNulTenantRecordId = (Long)MoreObjects.firstNonNull((Object)tenantRecordId, (Object)INTERNAL_TENANT_RECORD_ID);
        if (accountRecordId == null) {
            fixedOffsetTimeZone = null;
            referenceTime = null;
        } else {
            ImmutableAccountData immutableAccountData = this.getImmutableAccountData(accountRecordId, nonNulTenantRecordId);
            fixedOffsetTimeZone = immutableAccountData.getFixedOffsetTimeZone();
            referenceTime = immutableAccountData.getReferenceTime();
        }
        this.populateMDCContext(userToken, accountRecordId, nonNulTenantRecordId);
        return new InternalCallContext(nonNulTenantRecordId, accountRecordId, fixedOffsetTimeZone, referenceTime, userToken, userName, callOrigin, userType, reasonCode, comment, createdDate != null ? createdDate : this.clock.getUTCNow(), updatedDate != null ? createdDate : this.clock.getUTCNow());
    }

    private ImmutableAccountData getImmutableAccountData(Long accountRecordId, Long tenantRecordId) {
        Preconditions.checkNotNull((Object)accountRecordId, (Object)"Missing accountRecordId");
        InternalTenantContext tmp = new InternalTenantContext(tenantRecordId, accountRecordId, null, null);
        try {
            ImmutableAccountData immutableAccountData = this.accountInternalApi.getImmutableAccountDataByRecordId(accountRecordId, tmp);
            Preconditions.checkNotNull((Object)immutableAccountData, (Object)"Unable to retrieve immutableAccountData");
            return immutableAccountData;
        }
        catch (AccountApiException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateMDCContext(@Nullable UUID userToken, @Nullable Long accountRecordId, Long tenantRecordId) {
        if (accountRecordId != null) {
            MDC.put((String)MDC_KB_ACCOUNT_RECORD_ID, (String)String.valueOf(accountRecordId));
        }
        MDC.put((String)MDC_KB_TENANT_RECORD_ID, (String)String.valueOf(tenantRecordId));
        if (userToken != null) {
            MDC.put((String)MDC_KB_USER_TOKEN, (String)userToken.toString());
        }
    }

    public UUID getAccountId(UUID objectId, ObjectType objectType, TenantContext context) {
        Long accountRecordId = this.getAccountRecordIdSafe(objectId, objectType, context);
        if (accountRecordId != null) {
            return this.nonEntityDao.retrieveIdFromObject(accountRecordId, ObjectType.ACCOUNT, this.objectIdCacheController);
        }
        return null;
    }

    public Long getRecordIdFromObject(UUID objectId, ObjectType objectType, TenantContext context) {
        try {
            if (this.objectBelongsToTheRightTenant(objectId, objectType, context)) {
                return this.nonEntityDao.retrieveRecordIdFromObject(objectId, objectType, this.recordIdCacheController);
            }
            return null;
        }
        catch (ObjectDoesNotExist e) {
            return null;
        }
    }

    private Long getAccountRecordIdSafe(UUID objectId, ObjectType objectType, TenantContext context) {
        if (this.objectBelongsToTheRightTenant(objectId, objectType, context)) {
            return this.getAccountRecordIdUnsafe(objectId, objectType);
        }
        throw new IllegalStateException(String.format("Object id=%s type=%s doesn't belong to tenant id=%s", objectId, objectType, context.getTenantId()));
    }

    private Long getAccountRecordIdSafe(UUID objectId, ObjectType objectType, Long tenantRecordId) throws ObjectDoesNotExist {
        if (this.objectBelongsToTheRightTenant(objectId, objectType, tenantRecordId)) {
            return this.getAccountRecordIdUnsafe(objectId, objectType);
        }
        throw new IllegalStateException(String.format("Object id=%s type=%s doesn't belong to tenant recordId=%s", objectId, objectType, tenantRecordId));
    }

    private Long getTenantRecordIdSafe(TenantContext context) {
        if (context.getTenantId() == null) {
            return INTERNAL_TENANT_RECORD_ID;
        }
        return this.getTenantRecordIdUnsafe(context.getTenantId(), ObjectType.TENANT);
    }

    private UUID getTenantIdSafe(InternalTenantContext context) {
        return this.nonEntityDao.retrieveIdFromObject(context.getTenantRecordId(), ObjectType.TENANT, this.objectIdCacheController);
    }

    private UUID getAccountIdSafe(InternalTenantContext context) {
        return context.getAccountRecordId() != null ? this.nonEntityDao.retrieveIdFromObject(context.getAccountRecordId(), ObjectType.ACCOUNT, this.objectIdCacheController) : null;
    }

    private boolean objectBelongsToTheRightTenant(UUID objectId, ObjectType objectType, TenantContext context) throws ObjectDoesNotExist {
        Long realTenantRecordId = this.getTenantRecordIdSafe(context);
        if (realTenantRecordId == null) {
            throw new ObjectDoesNotExist(String.format("Tenant id=%s doesn't exist!", context.getTenantId()));
        }
        return this.objectBelongsToTheRightTenant(objectId, objectType, realTenantRecordId);
    }

    private boolean objectBelongsToTheRightTenant(UUID objectId, ObjectType objectType, Long realTenantRecordId) throws ObjectDoesNotExist {
        Long objectTenantRecordId = this.getTenantRecordIdUnsafe(objectId, objectType);
        return objectTenantRecordId.equals(realTenantRecordId);
    }

    private Long getAccountRecordIdUnsafe(UUID objectId, ObjectType objectType) {
        return this.nonEntityDao.retrieveAccountRecordIdFromObject(objectId, objectType, this.accountRecordIdCacheController);
    }

    private Long getTenantRecordIdUnsafe(UUID objectId, ObjectType objectType) {
        Long objectTenantRecordId = this.nonEntityDao.retrieveTenantRecordIdFromObject(objectId, objectType, this.tenantRecordIdCacheController);
        if (objectTenantRecordId == null) {
            throw new ObjectDoesNotExist(String.format("Object id=%s type=%s doesn't exist!", objectId, objectType));
        }
        return objectTenantRecordId;
    }

    public static final class ObjectDoesNotExist
    extends IllegalStateException {
        public ObjectDoesNotExist(String s) {
            super(s);
        }
    }
}

