/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.config;

import javax.inject.Inject;
import javax.inject.Named;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.util.config.ConfigKillbillService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigKillbillService
implements ConfigKillbillService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConfigKillbillService.class);
    private final TenantInternalApi tenantInternalApi;
    private final TenantInternalApi.CacheInvalidationCallback cacheInvalidationCallback;

    @Inject
    public DefaultConfigKillbillService(TenantInternalApi tenantInternalApi, @Named(value="ConfigInvalidationCallback") TenantInternalApi.CacheInvalidationCallback cacheInvalidationCallback) {
        this.tenantInternalApi = tenantInternalApi;
        this.cacheInvalidationCallback = cacheInvalidationCallback;
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.CONFIG_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.CONFIG_SERVICE.getRegistrationOrdering();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public synchronized void initialize() throws KillbillService.ServiceException {
        this.tenantInternalApi.initializeCacheInvalidationCallback(TenantKV.TenantKey.PER_TENANT_CONFIG, this.cacheInvalidationCallback);
    }
}

