/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.config.tenant;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.config.definition.KillbillConfig;
import org.killbill.billing.util.config.tenant.CacheConfig;
import org.killbill.billing.util.config.tenant.PerTenantConfig;
import org.skife.config.Config;
import org.skife.config.Separator;
import org.skife.config.TimeSpan;

public abstract class MultiTenantConfigBase {
    private final Map<String, Method> methodsCache = new HashMap<String, Method>();
    protected final CacheConfig cacheConfig;
    private static final Function<String, Integer> INT_CONVERTER = new Function<String, Integer>(){

        public Integer apply(String input) {
            return Integer.valueOf(input);
        }
    };
    private static final Function<String, TimeSpan> TIME_SPAN_CONVERTER = new Function<String, TimeSpan>(){

        public TimeSpan apply(String input) {
            return new TimeSpan(input);
        }
    };

    public MultiTenantConfigBase(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    protected List<String> convertToListString(String value, String methodName) {
        Method method = this.getConfigStaticMethodWithChecking(methodName);
        List<String> tokens = this.getTokens(method, value);
        return ImmutableList.copyOf(tokens);
    }

    protected List<TimeSpan> convertToListTimeSpan(String value, String methodName) {
        Method method = this.getConfigStaticMethodWithChecking(methodName);
        List<String> tokens = this.getTokens(method, value);
        return ImmutableList.copyOf((Iterable)Iterables.transform(tokens, TIME_SPAN_CONVERTER));
    }

    protected List<Integer> convertToListInteger(String value, String methodName) {
        Method method = this.getConfigStaticMethodWithChecking(methodName);
        List<String> tokens = this.getTokens(method, value);
        return ImmutableList.copyOf((Iterable)Iterables.transform(tokens, INT_CONVERTER));
    }

    protected String getStringTenantConfig(String methodName, InternalTenantContext tenantContext) {
        if (tenantContext == null) {
            return null;
        }
        Method method = this.getConfigStaticMethodWithChecking(methodName);
        return this.getCachedValue(method.getAnnotation(Config.class), tenantContext);
    }

    private String getCachedValue(Config annotation, InternalTenantContext tenantContext) {
        PerTenantConfig perTenantConfig = this.cacheConfig.getPerTenantConfig(tenantContext);
        for (String propertyName : annotation.value()) {
            String result = (String)perTenantConfig.get(propertyName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Method getConfigStaticMethodWithChecking(String methodName) {
        Method method = this.getConfigStaticMethod(methodName);
        if (!method.isAnnotationPresent(Config.class)) {
            throw new RuntimeException("Missing @Config annotation to skife config method " + method.getName());
        }
        return method;
    }

    private List<String> getTokens(Method method, String value) {
        Separator separator = method.getAnnotation(Separator.class);
        if (value == null || value.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])value.split(separator == null ? "\\s*,\\s*" : separator.value()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getConfigStaticMethod(String methodName) {
        Method method = this.methodsCache.get(methodName);
        if (method == null) {
            Map<String, Method> map = this.methodsCache;
            synchronized (map) {
                method = this.methodsCache.get(methodName);
                if (method == null) {
                    try {
                        method = this.getConfigClass().getMethod(methodName, InternalTenantContext.class);
                        this.methodsCache.put(methodName, method);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return method;
    }

    protected abstract Class<? extends KillbillConfig> getConfigClass();
}

