/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.StringCustomField;
import org.killbill.billing.util.customfield.dao.CustomFieldDao;
import org.killbill.billing.util.customfield.dao.CustomFieldModelDao;
import org.killbill.billing.util.customfield.dao.DefaultCustomFieldDao;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationHelper;

public class DefaultCustomFieldUserApi
implements CustomFieldUserApi {
    private static final Function<CustomFieldModelDao, CustomField> CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION = new Function<CustomFieldModelDao, CustomField>(){

        public CustomField apply(CustomFieldModelDao input) {
            return new StringCustomField(input);
        }
    };
    private final InternalCallContextFactory internalCallContextFactory;
    private final CustomFieldDao customFieldDao;

    @Inject
    public DefaultCustomFieldUserApi(InternalCallContextFactory internalCallContextFactory, CustomFieldDao customFieldDao) {
        this.internalCallContextFactory = internalCallContextFactory;
        this.customFieldDao = customFieldDao;
    }

    public Pagination<CustomField> searchCustomFields(final String searchKey, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<CustomFieldModelDao, CustomFieldApiException>(){

            @Override
            public Pagination<CustomFieldModelDao> build() {
                return DefaultCustomFieldUserApi.this.customFieldDao.searchCustomFields(searchKey, offset, limit, DefaultCustomFieldUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION);
    }

    public Pagination<CustomField> searchCustomFields(final String fieldName, final String fieldValue, final ObjectType objectType, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<CustomFieldModelDao, CustomFieldApiException>(){

            @Override
            public Pagination<CustomFieldModelDao> build() {
                return DefaultCustomFieldUserApi.this.customFieldDao.searchCustomFields(fieldName, fieldValue, objectType, offset, limit, DefaultCustomFieldUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION);
    }

    public Pagination<CustomField> searchCustomFields(final String fieldName, final ObjectType objectType, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<CustomFieldModelDao, CustomFieldApiException>(){

            @Override
            public Pagination<CustomFieldModelDao> build() {
                return DefaultCustomFieldUserApi.this.customFieldDao.searchCustomFields(fieldName, objectType, offset, limit, DefaultCustomFieldUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION);
    }

    public Pagination<CustomField> getCustomFields(final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<CustomFieldModelDao, CustomFieldApiException>(){

            @Override
            public Pagination<CustomFieldModelDao> build() {
                return DefaultCustomFieldUserApi.this.customFieldDao.get(offset, limit, DefaultCustomFieldUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION);
    }

    public void addCustomFields(List<CustomField> customFields, final CallContext context) throws CustomFieldApiException {
        if (!customFields.isEmpty()) {
            InternalCallContext internalCallContext = this.internalCallContextFactory.createInternalCallContext(customFields.get(0).getObjectId(), customFields.get(0).getObjectType(), context);
            Iterable transformed = Iterables.transform(customFields, (Function)new Function<CustomField, CustomFieldModelDao>(){

                public CustomFieldModelDao apply(CustomField input) {
                    if (input.getId() != null) {
                        return new CustomFieldModelDao(input.getId(), context.getCreatedDate(), context.getCreatedDate(), input.getFieldName(), input.getFieldValue(), input.getObjectId(), input.getObjectType());
                    }
                    return new CustomFieldModelDao(context.getCreatedDate(), input.getFieldName(), input.getFieldValue(), input.getObjectId(), input.getObjectType());
                }
            });
            ((DefaultCustomFieldDao)this.customFieldDao).create(transformed, internalCallContext);
        }
    }

    public void updateCustomFields(List<CustomField> customFields, CallContext context) throws CustomFieldApiException {
        if (!customFields.isEmpty()) {
            final InternalCallContext internalCallContext = this.internalCallContextFactory.createInternalCallContext(customFields.get(0).getObjectId(), customFields.get(0).getObjectType(), context);
            Iterable customFieldIds = Iterables.transform(customFields, (Function)new Function<CustomField, CustomFieldModelDao>(){

                public CustomFieldModelDao apply(CustomField input) {
                    return new CustomFieldModelDao(input.getId(), internalCallContext.getCreatedDate(), internalCallContext.getUpdatedDate(), input.getFieldName(), input.getFieldValue(), input.getObjectId(), input.getObjectType());
                }
            });
            this.customFieldDao.updateCustomFields(customFieldIds, internalCallContext);
        }
    }

    public void removeCustomFields(List<CustomField> customFields, CallContext context) throws CustomFieldApiException {
        if (!customFields.isEmpty()) {
            InternalCallContext internalCallContext = this.internalCallContextFactory.createInternalCallContext(customFields.get(0).getObjectId(), customFields.get(0).getObjectType(), context);
            Iterable curstomFieldIds = Iterables.transform(customFields, (Function)new Function<CustomField, UUID>(){

                public UUID apply(CustomField input) {
                    return input.getId();
                }
            });
            this.customFieldDao.deleteCustomFields(curstomFieldIds, internalCallContext);
        }
    }

    public List<CustomField> getCustomFieldsForObject(UUID objectId, ObjectType objectType, TenantContext context) {
        return this.withCustomFieldsTransform(this.customFieldDao.getCustomFieldsForObject(objectId, objectType, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)));
    }

    public List<CustomField> getCustomFieldsForAccountType(UUID accountId, ObjectType objectType, TenantContext context) {
        return this.withCustomFieldsTransform(this.customFieldDao.getCustomFieldsForAccountType(objectType, this.internalCallContextFactory.createInternalTenantContext(accountId, context)));
    }

    public List<CustomField> getCustomFieldsForAccount(UUID accountId, TenantContext context) {
        return this.withCustomFieldsTransform(this.customFieldDao.getCustomFieldsForAccount(this.internalCallContextFactory.createInternalTenantContext(accountId, context)));
    }

    public List<AuditLogWithHistory> getCustomFieldAuditLogsWithHistoryForId(UUID customFieldId, AuditLevel auditLevel, TenantContext tenantContext) {
        return this.customFieldDao.getCustomFieldAuditLogsWithHistoryForId(customFieldId, auditLevel, this.internalCallContextFactory.createInternalTenantContext(customFieldId, ObjectType.CUSTOM_FIELD, tenantContext));
    }

    private List<CustomField> withCustomFieldsTransform(Collection<CustomFieldModelDao> input) {
        return ImmutableList.copyOf((Collection)Collections2.transform(input, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION));
    }
}

